/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecs.model.ContainerDependenciesCopier;
import software.amazon.awssdk.services.ecs.model.ContainerDependency;
import software.amazon.awssdk.services.ecs.model.DockerLabelsMapCopier;
import software.amazon.awssdk.services.ecs.model.EnvironmentFile;
import software.amazon.awssdk.services.ecs.model.EnvironmentFilesCopier;
import software.amazon.awssdk.services.ecs.model.EnvironmentVariablesCopier;
import software.amazon.awssdk.services.ecs.model.FirelensConfiguration;
import software.amazon.awssdk.services.ecs.model.HealthCheck;
import software.amazon.awssdk.services.ecs.model.HostEntry;
import software.amazon.awssdk.services.ecs.model.HostEntryListCopier;
import software.amazon.awssdk.services.ecs.model.KeyValuePair;
import software.amazon.awssdk.services.ecs.model.LinuxParameters;
import software.amazon.awssdk.services.ecs.model.LogConfiguration;
import software.amazon.awssdk.services.ecs.model.MountPoint;
import software.amazon.awssdk.services.ecs.model.MountPointListCopier;
import software.amazon.awssdk.services.ecs.model.PortMapping;
import software.amazon.awssdk.services.ecs.model.PortMappingListCopier;
import software.amazon.awssdk.services.ecs.model.RepositoryCredentials;
import software.amazon.awssdk.services.ecs.model.ResourceRequirement;
import software.amazon.awssdk.services.ecs.model.ResourceRequirementsCopier;
import software.amazon.awssdk.services.ecs.model.Secret;
import software.amazon.awssdk.services.ecs.model.SecretListCopier;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.services.ecs.model.SystemControl;
import software.amazon.awssdk.services.ecs.model.SystemControlsCopier;
import software.amazon.awssdk.services.ecs.model.Ulimit;
import software.amazon.awssdk.services.ecs.model.UlimitListCopier;
import software.amazon.awssdk.services.ecs.model.VolumeFrom;
import software.amazon.awssdk.services.ecs.model.VolumeFromListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContainerDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContainerDefinition> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ContainerDefinition.getter(ContainerDefinition::name)).setter(ContainerDefinition.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("image").getter(ContainerDefinition.getter(ContainerDefinition::image)).setter(ContainerDefinition.setter(Builder::image)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final SdkField<RepositoryCredentials> REPOSITORY_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("repositoryCredentials").getter(ContainerDefinition.getter(ContainerDefinition::repositoryCredentials)).setter(ContainerDefinition.setter(Builder::repositoryCredentials)).constructor(RepositoryCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryCredentials").build()}).build();
    private static final SdkField<Integer> CPU_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("cpu").getter(ContainerDefinition.getter(ContainerDefinition::cpu)).setter(ContainerDefinition.setter(Builder::cpu)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpu").build()}).build();
    private static final SdkField<Integer> MEMORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memory").getter(ContainerDefinition.getter(ContainerDefinition::memory)).setter(ContainerDefinition.setter(Builder::memory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memory").build()}).build();
    private static final SdkField<Integer> MEMORY_RESERVATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("memoryReservation").getter(ContainerDefinition.getter(ContainerDefinition::memoryReservation)).setter(ContainerDefinition.setter(Builder::memoryReservation)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryReservation").build()}).build();
    private static final SdkField<List<String>> LINKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("links").getter(ContainerDefinition.getter(ContainerDefinition::links)).setter(ContainerDefinition.setter(Builder::links)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("links").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<PortMapping>> PORT_MAPPINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("portMappings").getter(ContainerDefinition.getter(ContainerDefinition::portMappings)).setter(ContainerDefinition.setter(Builder::portMappings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("portMappings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PortMapping::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> ESSENTIAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("essential").getter(ContainerDefinition.getter(ContainerDefinition::essential)).setter(ContainerDefinition.setter(Builder::essential)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("essential").build()}).build();
    private static final SdkField<List<String>> ENTRY_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entryPoint").getter(ContainerDefinition.getter(ContainerDefinition::entryPoint)).setter(ContainerDefinition.setter(Builder::entryPoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entryPoint").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> COMMAND_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("command").getter(ContainerDefinition.getter(ContainerDefinition::command)).setter(ContainerDefinition.setter(Builder::command)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("command").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<KeyValuePair>> ENVIRONMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environment").getter(ContainerDefinition.getter(ContainerDefinition::environment)).setter(ContainerDefinition.setter(Builder::environment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environment").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KeyValuePair::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentFile>> ENVIRONMENT_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentFiles").getter(ContainerDefinition.getter(ContainerDefinition::environmentFiles)).setter(ContainerDefinition.setter(Builder::environmentFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentFiles").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentFile::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<MountPoint>> MOUNT_POINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("mountPoints").getter(ContainerDefinition.getter(ContainerDefinition::mountPoints)).setter(ContainerDefinition.setter(Builder::mountPoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mountPoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(MountPoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<VolumeFrom>> VOLUMES_FROM_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("volumesFrom").getter(ContainerDefinition.getter(ContainerDefinition::volumesFrom)).setter(ContainerDefinition.setter(Builder::volumesFrom)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumesFrom").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VolumeFrom::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LinuxParameters> LINUX_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("linuxParameters").getter(ContainerDefinition.getter(ContainerDefinition::linuxParameters)).setter(ContainerDefinition.setter(Builder::linuxParameters)).constructor(LinuxParameters::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("linuxParameters").build()}).build();
    private static final SdkField<List<Secret>> SECRETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("secrets").getter(ContainerDefinition.getter(ContainerDefinition::secrets)).setter(ContainerDefinition.setter(Builder::secrets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("secrets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Secret::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ContainerDependency>> DEPENDS_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dependsOn").getter(ContainerDefinition.getter(ContainerDefinition::dependsOn)).setter(ContainerDefinition.setter(Builder::dependsOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependsOn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ContainerDependency::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Integer> START_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("startTimeout").getter(ContainerDefinition.getter(ContainerDefinition::startTimeout)).setter(ContainerDefinition.setter(Builder::startTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTimeout").build()}).build();
    private static final SdkField<Integer> STOP_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("stopTimeout").getter(ContainerDefinition.getter(ContainerDefinition::stopTimeout)).setter(ContainerDefinition.setter(Builder::stopTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stopTimeout").build()}).build();
    private static final SdkField<String> HOSTNAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("hostname").getter(ContainerDefinition.getter(ContainerDefinition::hostname)).setter(ContainerDefinition.setter(Builder::hostname)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostname").build()}).build();
    private static final SdkField<String> USER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("user").getter(ContainerDefinition.getter(ContainerDefinition::user)).setter(ContainerDefinition.setter(Builder::user)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("user").build()}).build();
    private static final SdkField<String> WORKING_DIRECTORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workingDirectory").getter(ContainerDefinition.getter(ContainerDefinition::workingDirectory)).setter(ContainerDefinition.setter(Builder::workingDirectory)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workingDirectory").build()}).build();
    private static final SdkField<Boolean> DISABLE_NETWORKING_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("disableNetworking").getter(ContainerDefinition.getter(ContainerDefinition::disableNetworking)).setter(ContainerDefinition.setter(Builder::disableNetworking)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("disableNetworking").build()}).build();
    private static final SdkField<Boolean> PRIVILEGED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("privileged").getter(ContainerDefinition.getter(ContainerDefinition::privileged)).setter(ContainerDefinition.setter(Builder::privileged)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("privileged").build()}).build();
    private static final SdkField<Boolean> READONLY_ROOT_FILESYSTEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("readonlyRootFilesystem").getter(ContainerDefinition.getter(ContainerDefinition::readonlyRootFilesystem)).setter(ContainerDefinition.setter(Builder::readonlyRootFilesystem)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("readonlyRootFilesystem").build()}).build();
    private static final SdkField<List<String>> DNS_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dnsServers").getter(ContainerDefinition.getter(ContainerDefinition::dnsServers)).setter(ContainerDefinition.setter(Builder::dnsServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsServers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DNS_SEARCH_DOMAINS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dnsSearchDomains").getter(ContainerDefinition.getter(ContainerDefinition::dnsSearchDomains)).setter(ContainerDefinition.setter(Builder::dnsSearchDomains)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dnsSearchDomains").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<HostEntry>> EXTRA_HOSTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("extraHosts").getter(ContainerDefinition.getter(ContainerDefinition::extraHosts)).setter(ContainerDefinition.setter(Builder::extraHosts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraHosts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(HostEntry::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> DOCKER_SECURITY_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("dockerSecurityOptions").getter(ContainerDefinition.getter(ContainerDefinition::dockerSecurityOptions)).setter(ContainerDefinition.setter(Builder::dockerSecurityOptions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerSecurityOptions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> INTERACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("interactive").getter(ContainerDefinition.getter(ContainerDefinition::interactive)).setter(ContainerDefinition.setter(Builder::interactive)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("interactive").build()}).build();
    private static final SdkField<Boolean> PSEUDO_TERMINAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("pseudoTerminal").getter(ContainerDefinition.getter(ContainerDefinition::pseudoTerminal)).setter(ContainerDefinition.setter(Builder::pseudoTerminal)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pseudoTerminal").build()}).build();
    private static final SdkField<Map<String, String>> DOCKER_LABELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("dockerLabels").getter(ContainerDefinition.getter(ContainerDefinition::dockerLabels)).setter(ContainerDefinition.setter(Builder::dockerLabels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dockerLabels").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<Ulimit>> ULIMITS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ulimits").getter(ContainerDefinition.getter(ContainerDefinition::ulimits)).setter(ContainerDefinition.setter(Builder::ulimits)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ulimits").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Ulimit::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LogConfiguration> LOG_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("logConfiguration").getter(ContainerDefinition.getter(ContainerDefinition::logConfiguration)).setter(ContainerDefinition.setter(Builder::logConfiguration)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfiguration").build()}).build();
    private static final SdkField<HealthCheck> HEALTH_CHECK_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("healthCheck").getter(ContainerDefinition.getter(ContainerDefinition::healthCheck)).setter(ContainerDefinition.setter(Builder::healthCheck)).constructor(HealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthCheck").build()}).build();
    private static final SdkField<List<SystemControl>> SYSTEM_CONTROLS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("systemControls").getter(ContainerDefinition.getter(ContainerDefinition::systemControls)).setter(ContainerDefinition.setter(Builder::systemControls)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("systemControls").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SystemControl::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ResourceRequirement>> RESOURCE_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceRequirements").getter(ContainerDefinition.getter(ContainerDefinition::resourceRequirements)).setter(ContainerDefinition.setter(Builder::resourceRequirements)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceRequirements").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceRequirement::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<FirelensConfiguration> FIRELENS_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("firelensConfiguration").getter(ContainerDefinition.getter(ContainerDefinition::firelensConfiguration)).setter(ContainerDefinition.setter(Builder::firelensConfiguration)).constructor(FirelensConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firelensConfiguration").build()}).build();
    private static final SdkField<List<String>> CREDENTIAL_SPECS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("credentialSpecs").getter(ContainerDefinition.getter(ContainerDefinition::credentialSpecs)).setter(ContainerDefinition.setter(Builder::credentialSpecs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialSpecs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_FIELD, REPOSITORY_CREDENTIALS_FIELD, CPU_FIELD, MEMORY_FIELD, MEMORY_RESERVATION_FIELD, LINKS_FIELD, PORT_MAPPINGS_FIELD, ESSENTIAL_FIELD, ENTRY_POINT_FIELD, COMMAND_FIELD, ENVIRONMENT_FIELD, ENVIRONMENT_FILES_FIELD, MOUNT_POINTS_FIELD, VOLUMES_FROM_FIELD, LINUX_PARAMETERS_FIELD, SECRETS_FIELD, DEPENDS_ON_FIELD, START_TIMEOUT_FIELD, STOP_TIMEOUT_FIELD, HOSTNAME_FIELD, USER_FIELD, WORKING_DIRECTORY_FIELD, DISABLE_NETWORKING_FIELD, PRIVILEGED_FIELD, READONLY_ROOT_FILESYSTEM_FIELD, DNS_SERVERS_FIELD, DNS_SEARCH_DOMAINS_FIELD, EXTRA_HOSTS_FIELD, DOCKER_SECURITY_OPTIONS_FIELD, INTERACTIVE_FIELD, PSEUDO_TERMINAL_FIELD, DOCKER_LABELS_FIELD, ULIMITS_FIELD, LOG_CONFIGURATION_FIELD, HEALTH_CHECK_FIELD, SYSTEM_CONTROLS_FIELD, RESOURCE_REQUIREMENTS_FIELD, FIRELENS_CONFIGURATION_FIELD, CREDENTIAL_SPECS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String image;
    private final RepositoryCredentials repositoryCredentials;
    private final Integer cpu;
    private final Integer memory;
    private final Integer memoryReservation;
    private final List<String> links;
    private final List<PortMapping> portMappings;
    private final Boolean essential;
    private final List<String> entryPoint;
    private final List<String> command;
    private final List<KeyValuePair> environment;
    private final List<EnvironmentFile> environmentFiles;
    private final List<MountPoint> mountPoints;
    private final List<VolumeFrom> volumesFrom;
    private final LinuxParameters linuxParameters;
    private final List<Secret> secrets;
    private final List<ContainerDependency> dependsOn;
    private final Integer startTimeout;
    private final Integer stopTimeout;
    private final String hostname;
    private final String user;
    private final String workingDirectory;
    private final Boolean disableNetworking;
    private final Boolean privileged;
    private final Boolean readonlyRootFilesystem;
    private final List<String> dnsServers;
    private final List<String> dnsSearchDomains;
    private final List<HostEntry> extraHosts;
    private final List<String> dockerSecurityOptions;
    private final Boolean interactive;
    private final Boolean pseudoTerminal;
    private final Map<String, String> dockerLabels;
    private final List<Ulimit> ulimits;
    private final LogConfiguration logConfiguration;
    private final HealthCheck healthCheck;
    private final List<SystemControl> systemControls;
    private final List<ResourceRequirement> resourceRequirements;
    private final FirelensConfiguration firelensConfiguration;
    private final List<String> credentialSpecs;

    private ContainerDefinition(BuilderImpl builder) {
        this.name = builder.name;
        this.image = builder.image;
        this.repositoryCredentials = builder.repositoryCredentials;
        this.cpu = builder.cpu;
        this.memory = builder.memory;
        this.memoryReservation = builder.memoryReservation;
        this.links = builder.links;
        this.portMappings = builder.portMappings;
        this.essential = builder.essential;
        this.entryPoint = builder.entryPoint;
        this.command = builder.command;
        this.environment = builder.environment;
        this.environmentFiles = builder.environmentFiles;
        this.mountPoints = builder.mountPoints;
        this.volumesFrom = builder.volumesFrom;
        this.linuxParameters = builder.linuxParameters;
        this.secrets = builder.secrets;
        this.dependsOn = builder.dependsOn;
        this.startTimeout = builder.startTimeout;
        this.stopTimeout = builder.stopTimeout;
        this.hostname = builder.hostname;
        this.user = builder.user;
        this.workingDirectory = builder.workingDirectory;
        this.disableNetworking = builder.disableNetworking;
        this.privileged = builder.privileged;
        this.readonlyRootFilesystem = builder.readonlyRootFilesystem;
        this.dnsServers = builder.dnsServers;
        this.dnsSearchDomains = builder.dnsSearchDomains;
        this.extraHosts = builder.extraHosts;
        this.dockerSecurityOptions = builder.dockerSecurityOptions;
        this.interactive = builder.interactive;
        this.pseudoTerminal = builder.pseudoTerminal;
        this.dockerLabels = builder.dockerLabels;
        this.ulimits = builder.ulimits;
        this.logConfiguration = builder.logConfiguration;
        this.healthCheck = builder.healthCheck;
        this.systemControls = builder.systemControls;
        this.resourceRequirements = builder.resourceRequirements;
        this.firelensConfiguration = builder.firelensConfiguration;
        this.credentialSpecs = builder.credentialSpecs;
    }

    public final String name() {
        return this.name;
    }

    public final String image() {
        return this.image;
    }

    public final RepositoryCredentials repositoryCredentials() {
        return this.repositoryCredentials;
    }

    public final Integer cpu() {
        return this.cpu;
    }

    public final Integer memory() {
        return this.memory;
    }

    public final Integer memoryReservation() {
        return this.memoryReservation;
    }

    public final boolean hasLinks() {
        return this.links != null && !(this.links instanceof SdkAutoConstructList);
    }

    public final List<String> links() {
        return this.links;
    }

    public final boolean hasPortMappings() {
        return this.portMappings != null && !(this.portMappings instanceof SdkAutoConstructList);
    }

    public final List<PortMapping> portMappings() {
        return this.portMappings;
    }

    public final Boolean essential() {
        return this.essential;
    }

    public final boolean hasEntryPoint() {
        return this.entryPoint != null && !(this.entryPoint instanceof SdkAutoConstructList);
    }

    public final List<String> entryPoint() {
        return this.entryPoint;
    }

    public final boolean hasCommand() {
        return this.command != null && !(this.command instanceof SdkAutoConstructList);
    }

    public final List<String> command() {
        return this.command;
    }

    public final boolean hasEnvironment() {
        return this.environment != null && !(this.environment instanceof SdkAutoConstructList);
    }

    public final List<KeyValuePair> environment() {
        return this.environment;
    }

    public final boolean hasEnvironmentFiles() {
        return this.environmentFiles != null && !(this.environmentFiles instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentFile> environmentFiles() {
        return this.environmentFiles;
    }

    public final boolean hasMountPoints() {
        return this.mountPoints != null && !(this.mountPoints instanceof SdkAutoConstructList);
    }

    public final List<MountPoint> mountPoints() {
        return this.mountPoints;
    }

    public final boolean hasVolumesFrom() {
        return this.volumesFrom != null && !(this.volumesFrom instanceof SdkAutoConstructList);
    }

    public final List<VolumeFrom> volumesFrom() {
        return this.volumesFrom;
    }

    public final LinuxParameters linuxParameters() {
        return this.linuxParameters;
    }

    public final boolean hasSecrets() {
        return this.secrets != null && !(this.secrets instanceof SdkAutoConstructList);
    }

    public final List<Secret> secrets() {
        return this.secrets;
    }

    public final boolean hasDependsOn() {
        return this.dependsOn != null && !(this.dependsOn instanceof SdkAutoConstructList);
    }

    public final List<ContainerDependency> dependsOn() {
        return this.dependsOn;
    }

    public final Integer startTimeout() {
        return this.startTimeout;
    }

    public final Integer stopTimeout() {
        return this.stopTimeout;
    }

    public final String hostname() {
        return this.hostname;
    }

    public final String user() {
        return this.user;
    }

    public final String workingDirectory() {
        return this.workingDirectory;
    }

    public final Boolean disableNetworking() {
        return this.disableNetworking;
    }

    public final Boolean privileged() {
        return this.privileged;
    }

    public final Boolean readonlyRootFilesystem() {
        return this.readonlyRootFilesystem;
    }

    public final boolean hasDnsServers() {
        return this.dnsServers != null && !(this.dnsServers instanceof SdkAutoConstructList);
    }

    public final List<String> dnsServers() {
        return this.dnsServers;
    }

    public final boolean hasDnsSearchDomains() {
        return this.dnsSearchDomains != null && !(this.dnsSearchDomains instanceof SdkAutoConstructList);
    }

    public final List<String> dnsSearchDomains() {
        return this.dnsSearchDomains;
    }

    public final boolean hasExtraHosts() {
        return this.extraHosts != null && !(this.extraHosts instanceof SdkAutoConstructList);
    }

    public final List<HostEntry> extraHosts() {
        return this.extraHosts;
    }

    public final boolean hasDockerSecurityOptions() {
        return this.dockerSecurityOptions != null && !(this.dockerSecurityOptions instanceof SdkAutoConstructList);
    }

    public final List<String> dockerSecurityOptions() {
        return this.dockerSecurityOptions;
    }

    public final Boolean interactive() {
        return this.interactive;
    }

    public final Boolean pseudoTerminal() {
        return this.pseudoTerminal;
    }

    public final boolean hasDockerLabels() {
        return this.dockerLabels != null && !(this.dockerLabels instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> dockerLabels() {
        return this.dockerLabels;
    }

    public final boolean hasUlimits() {
        return this.ulimits != null && !(this.ulimits instanceof SdkAutoConstructList);
    }

    public final List<Ulimit> ulimits() {
        return this.ulimits;
    }

    public final LogConfiguration logConfiguration() {
        return this.logConfiguration;
    }

    public final HealthCheck healthCheck() {
        return this.healthCheck;
    }

    public final boolean hasSystemControls() {
        return this.systemControls != null && !(this.systemControls instanceof SdkAutoConstructList);
    }

    public final List<SystemControl> systemControls() {
        return this.systemControls;
    }

    public final boolean hasResourceRequirements() {
        return this.resourceRequirements != null && !(this.resourceRequirements instanceof SdkAutoConstructList);
    }

    public final List<ResourceRequirement> resourceRequirements() {
        return this.resourceRequirements;
    }

    public final FirelensConfiguration firelensConfiguration() {
        return this.firelensConfiguration;
    }

    public final boolean hasCredentialSpecs() {
        return this.credentialSpecs != null && !(this.credentialSpecs instanceof SdkAutoConstructList);
    }

    public final List<String> credentialSpecs() {
        return this.credentialSpecs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpu());
        hashCode = 31 * hashCode + Objects.hashCode(this.memory());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryReservation());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLinks() ? this.links() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPortMappings() ? this.portMappings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.essential());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntryPoint() ? this.entryPoint() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCommand() ? this.command() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironment() ? this.environment() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentFiles() ? this.environmentFiles() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasMountPoints() ? this.mountPoints() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVolumesFrom() ? this.volumesFrom() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.linuxParameters());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecrets() ? this.secrets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDependsOn() ? this.dependsOn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.startTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.stopTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostname());
        hashCode = 31 * hashCode + Objects.hashCode(this.user());
        hashCode = 31 * hashCode + Objects.hashCode(this.workingDirectory());
        hashCode = 31 * hashCode + Objects.hashCode(this.disableNetworking());
        hashCode = 31 * hashCode + Objects.hashCode(this.privileged());
        hashCode = 31 * hashCode + Objects.hashCode(this.readonlyRootFilesystem());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsServers() ? this.dnsServers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDnsSearchDomains() ? this.dnsSearchDomains() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExtraHosts() ? this.extraHosts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDockerSecurityOptions() ? this.dockerSecurityOptions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.interactive());
        hashCode = 31 * hashCode + Objects.hashCode(this.pseudoTerminal());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDockerLabels() ? this.dockerLabels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUlimits() ? this.ulimits() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.logConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.healthCheck());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSystemControls() ? this.systemControls() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceRequirements() ? this.resourceRequirements() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.firelensConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialSpecs() ? this.credentialSpecs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContainerDefinition)) {
            return false;
        }
        ContainerDefinition other = (ContainerDefinition)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.image(), other.image()) && Objects.equals(this.repositoryCredentials(), other.repositoryCredentials()) && Objects.equals(this.cpu(), other.cpu()) && Objects.equals(this.memory(), other.memory()) && Objects.equals(this.memoryReservation(), other.memoryReservation()) && this.hasLinks() == other.hasLinks() && Objects.equals(this.links(), other.links()) && this.hasPortMappings() == other.hasPortMappings() && Objects.equals(this.portMappings(), other.portMappings()) && Objects.equals(this.essential(), other.essential()) && this.hasEntryPoint() == other.hasEntryPoint() && Objects.equals(this.entryPoint(), other.entryPoint()) && this.hasCommand() == other.hasCommand() && Objects.equals(this.command(), other.command()) && this.hasEnvironment() == other.hasEnvironment() && Objects.equals(this.environment(), other.environment()) && this.hasEnvironmentFiles() == other.hasEnvironmentFiles() && Objects.equals(this.environmentFiles(), other.environmentFiles()) && this.hasMountPoints() == other.hasMountPoints() && Objects.equals(this.mountPoints(), other.mountPoints()) && this.hasVolumesFrom() == other.hasVolumesFrom() && Objects.equals(this.volumesFrom(), other.volumesFrom()) && Objects.equals(this.linuxParameters(), other.linuxParameters()) && this.hasSecrets() == other.hasSecrets() && Objects.equals(this.secrets(), other.secrets()) && this.hasDependsOn() == other.hasDependsOn() && Objects.equals(this.dependsOn(), other.dependsOn()) && Objects.equals(this.startTimeout(), other.startTimeout()) && Objects.equals(this.stopTimeout(), other.stopTimeout()) && Objects.equals(this.hostname(), other.hostname()) && Objects.equals(this.user(), other.user()) && Objects.equals(this.workingDirectory(), other.workingDirectory()) && Objects.equals(this.disableNetworking(), other.disableNetworking()) && Objects.equals(this.privileged(), other.privileged()) && Objects.equals(this.readonlyRootFilesystem(), other.readonlyRootFilesystem()) && this.hasDnsServers() == other.hasDnsServers() && Objects.equals(this.dnsServers(), other.dnsServers()) && this.hasDnsSearchDomains() == other.hasDnsSearchDomains() && Objects.equals(this.dnsSearchDomains(), other.dnsSearchDomains()) && this.hasExtraHosts() == other.hasExtraHosts() && Objects.equals(this.extraHosts(), other.extraHosts()) && this.hasDockerSecurityOptions() == other.hasDockerSecurityOptions() && Objects.equals(this.dockerSecurityOptions(), other.dockerSecurityOptions()) && Objects.equals(this.interactive(), other.interactive()) && Objects.equals(this.pseudoTerminal(), other.pseudoTerminal()) && this.hasDockerLabels() == other.hasDockerLabels() && Objects.equals(this.dockerLabels(), other.dockerLabels()) && this.hasUlimits() == other.hasUlimits() && Objects.equals(this.ulimits(), other.ulimits()) && Objects.equals(this.logConfiguration(), other.logConfiguration()) && Objects.equals(this.healthCheck(), other.healthCheck()) && this.hasSystemControls() == other.hasSystemControls() && Objects.equals(this.systemControls(), other.systemControls()) && this.hasResourceRequirements() == other.hasResourceRequirements() && Objects.equals(this.resourceRequirements(), other.resourceRequirements()) && Objects.equals(this.firelensConfiguration(), other.firelensConfiguration()) && this.hasCredentialSpecs() == other.hasCredentialSpecs() && Objects.equals(this.credentialSpecs(), other.credentialSpecs());
    }

    public final String toString() {
        return ToString.builder((String)"ContainerDefinition").add("Name", (Object)this.name()).add("Image", (Object)this.image()).add("RepositoryCredentials", (Object)this.repositoryCredentials()).add("Cpu", (Object)this.cpu()).add("Memory", (Object)this.memory()).add("MemoryReservation", (Object)this.memoryReservation()).add("Links", this.hasLinks() ? this.links() : null).add("PortMappings", this.hasPortMappings() ? this.portMappings() : null).add("Essential", (Object)this.essential()).add("EntryPoint", this.hasEntryPoint() ? this.entryPoint() : null).add("Command", this.hasCommand() ? this.command() : null).add("Environment", this.hasEnvironment() ? this.environment() : null).add("EnvironmentFiles", this.hasEnvironmentFiles() ? this.environmentFiles() : null).add("MountPoints", this.hasMountPoints() ? this.mountPoints() : null).add("VolumesFrom", this.hasVolumesFrom() ? this.volumesFrom() : null).add("LinuxParameters", (Object)this.linuxParameters()).add("Secrets", this.hasSecrets() ? this.secrets() : null).add("DependsOn", this.hasDependsOn() ? this.dependsOn() : null).add("StartTimeout", (Object)this.startTimeout()).add("StopTimeout", (Object)this.stopTimeout()).add("Hostname", (Object)this.hostname()).add("User", (Object)this.user()).add("WorkingDirectory", (Object)this.workingDirectory()).add("DisableNetworking", (Object)this.disableNetworking()).add("Privileged", (Object)this.privileged()).add("ReadonlyRootFilesystem", (Object)this.readonlyRootFilesystem()).add("DnsServers", this.hasDnsServers() ? this.dnsServers() : null).add("DnsSearchDomains", this.hasDnsSearchDomains() ? this.dnsSearchDomains() : null).add("ExtraHosts", this.hasExtraHosts() ? this.extraHosts() : null).add("DockerSecurityOptions", this.hasDockerSecurityOptions() ? this.dockerSecurityOptions() : null).add("Interactive", (Object)this.interactive()).add("PseudoTerminal", (Object)this.pseudoTerminal()).add("DockerLabels", this.hasDockerLabels() ? this.dockerLabels() : null).add("Ulimits", this.hasUlimits() ? this.ulimits() : null).add("LogConfiguration", (Object)this.logConfiguration()).add("HealthCheck", (Object)this.healthCheck()).add("SystemControls", this.hasSystemControls() ? this.systemControls() : null).add("ResourceRequirements", this.hasResourceRequirements() ? this.resourceRequirements() : null).add("FirelensConfiguration", (Object)this.firelensConfiguration()).add("CredentialSpecs", this.hasCredentialSpecs() ? this.credentialSpecs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
            case "repositoryCredentials": {
                return Optional.ofNullable(clazz.cast(this.repositoryCredentials()));
            }
            case "cpu": {
                return Optional.ofNullable(clazz.cast(this.cpu()));
            }
            case "memory": {
                return Optional.ofNullable(clazz.cast(this.memory()));
            }
            case "memoryReservation": {
                return Optional.ofNullable(clazz.cast(this.memoryReservation()));
            }
            case "links": {
                return Optional.ofNullable(clazz.cast(this.links()));
            }
            case "portMappings": {
                return Optional.ofNullable(clazz.cast(this.portMappings()));
            }
            case "essential": {
                return Optional.ofNullable(clazz.cast(this.essential()));
            }
            case "entryPoint": {
                return Optional.ofNullable(clazz.cast(this.entryPoint()));
            }
            case "command": {
                return Optional.ofNullable(clazz.cast(this.command()));
            }
            case "environment": {
                return Optional.ofNullable(clazz.cast(this.environment()));
            }
            case "environmentFiles": {
                return Optional.ofNullable(clazz.cast(this.environmentFiles()));
            }
            case "mountPoints": {
                return Optional.ofNullable(clazz.cast(this.mountPoints()));
            }
            case "volumesFrom": {
                return Optional.ofNullable(clazz.cast(this.volumesFrom()));
            }
            case "linuxParameters": {
                return Optional.ofNullable(clazz.cast(this.linuxParameters()));
            }
            case "secrets": {
                return Optional.ofNullable(clazz.cast(this.secrets()));
            }
            case "dependsOn": {
                return Optional.ofNullable(clazz.cast(this.dependsOn()));
            }
            case "startTimeout": {
                return Optional.ofNullable(clazz.cast(this.startTimeout()));
            }
            case "stopTimeout": {
                return Optional.ofNullable(clazz.cast(this.stopTimeout()));
            }
            case "hostname": {
                return Optional.ofNullable(clazz.cast(this.hostname()));
            }
            case "user": {
                return Optional.ofNullable(clazz.cast(this.user()));
            }
            case "workingDirectory": {
                return Optional.ofNullable(clazz.cast(this.workingDirectory()));
            }
            case "disableNetworking": {
                return Optional.ofNullable(clazz.cast(this.disableNetworking()));
            }
            case "privileged": {
                return Optional.ofNullable(clazz.cast(this.privileged()));
            }
            case "readonlyRootFilesystem": {
                return Optional.ofNullable(clazz.cast(this.readonlyRootFilesystem()));
            }
            case "dnsServers": {
                return Optional.ofNullable(clazz.cast(this.dnsServers()));
            }
            case "dnsSearchDomains": {
                return Optional.ofNullable(clazz.cast(this.dnsSearchDomains()));
            }
            case "extraHosts": {
                return Optional.ofNullable(clazz.cast(this.extraHosts()));
            }
            case "dockerSecurityOptions": {
                return Optional.ofNullable(clazz.cast(this.dockerSecurityOptions()));
            }
            case "interactive": {
                return Optional.ofNullable(clazz.cast(this.interactive()));
            }
            case "pseudoTerminal": {
                return Optional.ofNullable(clazz.cast(this.pseudoTerminal()));
            }
            case "dockerLabels": {
                return Optional.ofNullable(clazz.cast(this.dockerLabels()));
            }
            case "ulimits": {
                return Optional.ofNullable(clazz.cast(this.ulimits()));
            }
            case "logConfiguration": {
                return Optional.ofNullable(clazz.cast(this.logConfiguration()));
            }
            case "healthCheck": {
                return Optional.ofNullable(clazz.cast(this.healthCheck()));
            }
            case "systemControls": {
                return Optional.ofNullable(clazz.cast(this.systemControls()));
            }
            case "resourceRequirements": {
                return Optional.ofNullable(clazz.cast(this.resourceRequirements()));
            }
            case "firelensConfiguration": {
                return Optional.ofNullable(clazz.cast(this.firelensConfiguration()));
            }
            case "credentialSpecs": {
                return Optional.ofNullable(clazz.cast(this.credentialSpecs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContainerDefinition, T> g) {
        return obj -> g.apply((ContainerDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String image;
        private RepositoryCredentials repositoryCredentials;
        private Integer cpu;
        private Integer memory;
        private Integer memoryReservation;
        private List<String> links = DefaultSdkAutoConstructList.getInstance();
        private List<PortMapping> portMappings = DefaultSdkAutoConstructList.getInstance();
        private Boolean essential;
        private List<String> entryPoint = DefaultSdkAutoConstructList.getInstance();
        private List<String> command = DefaultSdkAutoConstructList.getInstance();
        private List<KeyValuePair> environment = DefaultSdkAutoConstructList.getInstance();
        private List<EnvironmentFile> environmentFiles = DefaultSdkAutoConstructList.getInstance();
        private List<MountPoint> mountPoints = DefaultSdkAutoConstructList.getInstance();
        private List<VolumeFrom> volumesFrom = DefaultSdkAutoConstructList.getInstance();
        private LinuxParameters linuxParameters;
        private List<Secret> secrets = DefaultSdkAutoConstructList.getInstance();
        private List<ContainerDependency> dependsOn = DefaultSdkAutoConstructList.getInstance();
        private Integer startTimeout;
        private Integer stopTimeout;
        private String hostname;
        private String user;
        private String workingDirectory;
        private Boolean disableNetworking;
        private Boolean privileged;
        private Boolean readonlyRootFilesystem;
        private List<String> dnsServers = DefaultSdkAutoConstructList.getInstance();
        private List<String> dnsSearchDomains = DefaultSdkAutoConstructList.getInstance();
        private List<HostEntry> extraHosts = DefaultSdkAutoConstructList.getInstance();
        private List<String> dockerSecurityOptions = DefaultSdkAutoConstructList.getInstance();
        private Boolean interactive;
        private Boolean pseudoTerminal;
        private Map<String, String> dockerLabels = DefaultSdkAutoConstructMap.getInstance();
        private List<Ulimit> ulimits = DefaultSdkAutoConstructList.getInstance();
        private LogConfiguration logConfiguration;
        private HealthCheck healthCheck;
        private List<SystemControl> systemControls = DefaultSdkAutoConstructList.getInstance();
        private List<ResourceRequirement> resourceRequirements = DefaultSdkAutoConstructList.getInstance();
        private FirelensConfiguration firelensConfiguration;
        private List<String> credentialSpecs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ContainerDefinition model) {
            this.name(model.name);
            this.image(model.image);
            this.repositoryCredentials(model.repositoryCredentials);
            this.cpu(model.cpu);
            this.memory(model.memory);
            this.memoryReservation(model.memoryReservation);
            this.links(model.links);
            this.portMappings(model.portMappings);
            this.essential(model.essential);
            this.entryPoint(model.entryPoint);
            this.command(model.command);
            this.environment(model.environment);
            this.environmentFiles(model.environmentFiles);
            this.mountPoints(model.mountPoints);
            this.volumesFrom(model.volumesFrom);
            this.linuxParameters(model.linuxParameters);
            this.secrets(model.secrets);
            this.dependsOn(model.dependsOn);
            this.startTimeout(model.startTimeout);
            this.stopTimeout(model.stopTimeout);
            this.hostname(model.hostname);
            this.user(model.user);
            this.workingDirectory(model.workingDirectory);
            this.disableNetworking(model.disableNetworking);
            this.privileged(model.privileged);
            this.readonlyRootFilesystem(model.readonlyRootFilesystem);
            this.dnsServers(model.dnsServers);
            this.dnsSearchDomains(model.dnsSearchDomains);
            this.extraHosts(model.extraHosts);
            this.dockerSecurityOptions(model.dockerSecurityOptions);
            this.interactive(model.interactive);
            this.pseudoTerminal(model.pseudoTerminal);
            this.dockerLabels(model.dockerLabels);
            this.ulimits(model.ulimits);
            this.logConfiguration(model.logConfiguration);
            this.healthCheck(model.healthCheck);
            this.systemControls(model.systemControls);
            this.resourceRequirements(model.resourceRequirements);
            this.firelensConfiguration(model.firelensConfiguration);
            this.credentialSpecs(model.credentialSpecs);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getImage() {
            return this.image;
        }

        public final void setImage(String image) {
            this.image = image;
        }

        @Override
        public final Builder image(String image) {
            this.image = image;
            return this;
        }

        public final RepositoryCredentials.Builder getRepositoryCredentials() {
            return this.repositoryCredentials != null ? this.repositoryCredentials.toBuilder() : null;
        }

        public final void setRepositoryCredentials(RepositoryCredentials.BuilderImpl repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials != null ? repositoryCredentials.build() : null;
        }

        @Override
        public final Builder repositoryCredentials(RepositoryCredentials repositoryCredentials) {
            this.repositoryCredentials = repositoryCredentials;
            return this;
        }

        public final Integer getCpu() {
            return this.cpu;
        }

        public final void setCpu(Integer cpu) {
            this.cpu = cpu;
        }

        @Override
        public final Builder cpu(Integer cpu) {
            this.cpu = cpu;
            return this;
        }

        public final Integer getMemory() {
            return this.memory;
        }

        public final void setMemory(Integer memory) {
            this.memory = memory;
        }

        @Override
        public final Builder memory(Integer memory) {
            this.memory = memory;
            return this;
        }

        public final Integer getMemoryReservation() {
            return this.memoryReservation;
        }

        public final void setMemoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
        }

        @Override
        public final Builder memoryReservation(Integer memoryReservation) {
            this.memoryReservation = memoryReservation;
            return this;
        }

        public final Collection<String> getLinks() {
            if (this.links instanceof SdkAutoConstructList) {
                return null;
            }
            return this.links;
        }

        public final void setLinks(Collection<String> links) {
            this.links = StringListCopier.copy(links);
        }

        @Override
        public final Builder links(Collection<String> links) {
            this.links = StringListCopier.copy(links);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder links(String ... links) {
            this.links(Arrays.asList(links));
            return this;
        }

        public final List<PortMapping.Builder> getPortMappings() {
            List<PortMapping.Builder> result = PortMappingListCopier.copyToBuilder(this.portMappings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPortMappings(Collection<PortMapping.BuilderImpl> portMappings) {
            this.portMappings = PortMappingListCopier.copyFromBuilder(portMappings);
        }

        @Override
        public final Builder portMappings(Collection<PortMapping> portMappings) {
            this.portMappings = PortMappingListCopier.copy(portMappings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(PortMapping ... portMappings) {
            this.portMappings(Arrays.asList(portMappings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder portMappings(Consumer<PortMapping.Builder> ... portMappings) {
            this.portMappings(Stream.of(portMappings).map(c -> (PortMapping)((PortMapping.Builder)PortMapping.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEssential() {
            return this.essential;
        }

        public final void setEssential(Boolean essential) {
            this.essential = essential;
        }

        @Override
        public final Builder essential(Boolean essential) {
            this.essential = essential;
            return this;
        }

        public final Collection<String> getEntryPoint() {
            if (this.entryPoint instanceof SdkAutoConstructList) {
                return null;
            }
            return this.entryPoint;
        }

        public final void setEntryPoint(Collection<String> entryPoint) {
            this.entryPoint = StringListCopier.copy(entryPoint);
        }

        @Override
        public final Builder entryPoint(Collection<String> entryPoint) {
            this.entryPoint = StringListCopier.copy(entryPoint);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entryPoint(String ... entryPoint) {
            this.entryPoint(Arrays.asList(entryPoint));
            return this;
        }

        public final Collection<String> getCommand() {
            if (this.command instanceof SdkAutoConstructList) {
                return null;
            }
            return this.command;
        }

        public final void setCommand(Collection<String> command) {
            this.command = StringListCopier.copy(command);
        }

        @Override
        public final Builder command(Collection<String> command) {
            this.command = StringListCopier.copy(command);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder command(String ... command) {
            this.command(Arrays.asList(command));
            return this;
        }

        public final List<KeyValuePair.Builder> getEnvironment() {
            List<KeyValuePair.Builder> result = EnvironmentVariablesCopier.copyToBuilder(this.environment);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironment(Collection<KeyValuePair.BuilderImpl> environment) {
            this.environment = EnvironmentVariablesCopier.copyFromBuilder(environment);
        }

        @Override
        public final Builder environment(Collection<KeyValuePair> environment) {
            this.environment = EnvironmentVariablesCopier.copy(environment);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(KeyValuePair ... environment) {
            this.environment(Arrays.asList(environment));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environment(Consumer<KeyValuePair.Builder> ... environment) {
            this.environment(Stream.of(environment).map(c -> (KeyValuePair)((KeyValuePair.Builder)KeyValuePair.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EnvironmentFile.Builder> getEnvironmentFiles() {
            List<EnvironmentFile.Builder> result = EnvironmentFilesCopier.copyToBuilder(this.environmentFiles);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentFiles(Collection<EnvironmentFile.BuilderImpl> environmentFiles) {
            this.environmentFiles = EnvironmentFilesCopier.copyFromBuilder(environmentFiles);
        }

        @Override
        public final Builder environmentFiles(Collection<EnvironmentFile> environmentFiles) {
            this.environmentFiles = EnvironmentFilesCopier.copy(environmentFiles);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(EnvironmentFile ... environmentFiles) {
            this.environmentFiles(Arrays.asList(environmentFiles));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentFiles(Consumer<EnvironmentFile.Builder> ... environmentFiles) {
            this.environmentFiles(Stream.of(environmentFiles).map(c -> (EnvironmentFile)((EnvironmentFile.Builder)EnvironmentFile.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<MountPoint.Builder> getMountPoints() {
            List<MountPoint.Builder> result = MountPointListCopier.copyToBuilder(this.mountPoints);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMountPoints(Collection<MountPoint.BuilderImpl> mountPoints) {
            this.mountPoints = MountPointListCopier.copyFromBuilder(mountPoints);
        }

        @Override
        public final Builder mountPoints(Collection<MountPoint> mountPoints) {
            this.mountPoints = MountPointListCopier.copy(mountPoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(MountPoint ... mountPoints) {
            this.mountPoints(Arrays.asList(mountPoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder mountPoints(Consumer<MountPoint.Builder> ... mountPoints) {
            this.mountPoints(Stream.of(mountPoints).map(c -> (MountPoint)((MountPoint.Builder)MountPoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<VolumeFrom.Builder> getVolumesFrom() {
            List<VolumeFrom.Builder> result = VolumeFromListCopier.copyToBuilder(this.volumesFrom);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVolumesFrom(Collection<VolumeFrom.BuilderImpl> volumesFrom) {
            this.volumesFrom = VolumeFromListCopier.copyFromBuilder(volumesFrom);
        }

        @Override
        public final Builder volumesFrom(Collection<VolumeFrom> volumesFrom) {
            this.volumesFrom = VolumeFromListCopier.copy(volumesFrom);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesFrom(VolumeFrom ... volumesFrom) {
            this.volumesFrom(Arrays.asList(volumesFrom));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder volumesFrom(Consumer<VolumeFrom.Builder> ... volumesFrom) {
            this.volumesFrom(Stream.of(volumesFrom).map(c -> (VolumeFrom)((VolumeFrom.Builder)VolumeFrom.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LinuxParameters.Builder getLinuxParameters() {
            return this.linuxParameters != null ? this.linuxParameters.toBuilder() : null;
        }

        public final void setLinuxParameters(LinuxParameters.BuilderImpl linuxParameters) {
            this.linuxParameters = linuxParameters != null ? linuxParameters.build() : null;
        }

        @Override
        public final Builder linuxParameters(LinuxParameters linuxParameters) {
            this.linuxParameters = linuxParameters;
            return this;
        }

        public final List<Secret.Builder> getSecrets() {
            List<Secret.Builder> result = SecretListCopier.copyToBuilder(this.secrets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecrets(Collection<Secret.BuilderImpl> secrets) {
            this.secrets = SecretListCopier.copyFromBuilder(secrets);
        }

        @Override
        public final Builder secrets(Collection<Secret> secrets) {
            this.secrets = SecretListCopier.copy(secrets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Secret ... secrets) {
            this.secrets(Arrays.asList(secrets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder secrets(Consumer<Secret.Builder> ... secrets) {
            this.secrets(Stream.of(secrets).map(c -> (Secret)((Secret.Builder)Secret.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ContainerDependency.Builder> getDependsOn() {
            List<ContainerDependency.Builder> result = ContainerDependenciesCopier.copyToBuilder(this.dependsOn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setDependsOn(Collection<ContainerDependency.BuilderImpl> dependsOn) {
            this.dependsOn = ContainerDependenciesCopier.copyFromBuilder(dependsOn);
        }

        @Override
        public final Builder dependsOn(Collection<ContainerDependency> dependsOn) {
            this.dependsOn = ContainerDependenciesCopier.copy(dependsOn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(ContainerDependency ... dependsOn) {
            this.dependsOn(Arrays.asList(dependsOn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependsOn(Consumer<ContainerDependency.Builder> ... dependsOn) {
            this.dependsOn(Stream.of(dependsOn).map(c -> (ContainerDependency)((ContainerDependency.Builder)ContainerDependency.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Integer getStartTimeout() {
            return this.startTimeout;
        }

        public final void setStartTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
        }

        @Override
        public final Builder startTimeout(Integer startTimeout) {
            this.startTimeout = startTimeout;
            return this;
        }

        public final Integer getStopTimeout() {
            return this.stopTimeout;
        }

        public final void setStopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
        }

        @Override
        public final Builder stopTimeout(Integer stopTimeout) {
            this.stopTimeout = stopTimeout;
            return this;
        }

        public final String getHostname() {
            return this.hostname;
        }

        public final void setHostname(String hostname) {
            this.hostname = hostname;
        }

        @Override
        public final Builder hostname(String hostname) {
            this.hostname = hostname;
            return this;
        }

        public final String getUser() {
            return this.user;
        }

        public final void setUser(String user) {
            this.user = user;
        }

        @Override
        public final Builder user(String user) {
            this.user = user;
            return this;
        }

        public final String getWorkingDirectory() {
            return this.workingDirectory;
        }

        public final void setWorkingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
        }

        @Override
        public final Builder workingDirectory(String workingDirectory) {
            this.workingDirectory = workingDirectory;
            return this;
        }

        public final Boolean getDisableNetworking() {
            return this.disableNetworking;
        }

        public final void setDisableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
        }

        @Override
        public final Builder disableNetworking(Boolean disableNetworking) {
            this.disableNetworking = disableNetworking;
            return this;
        }

        public final Boolean getPrivileged() {
            return this.privileged;
        }

        public final void setPrivileged(Boolean privileged) {
            this.privileged = privileged;
        }

        @Override
        public final Builder privileged(Boolean privileged) {
            this.privileged = privileged;
            return this;
        }

        public final Boolean getReadonlyRootFilesystem() {
            return this.readonlyRootFilesystem;
        }

        public final void setReadonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
        }

        @Override
        public final Builder readonlyRootFilesystem(Boolean readonlyRootFilesystem) {
            this.readonlyRootFilesystem = readonlyRootFilesystem;
            return this;
        }

        public final Collection<String> getDnsServers() {
            if (this.dnsServers instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsServers;
        }

        public final void setDnsServers(Collection<String> dnsServers) {
            this.dnsServers = StringListCopier.copy(dnsServers);
        }

        @Override
        public final Builder dnsServers(Collection<String> dnsServers) {
            this.dnsServers = StringListCopier.copy(dnsServers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsServers(String ... dnsServers) {
            this.dnsServers(Arrays.asList(dnsServers));
            return this;
        }

        public final Collection<String> getDnsSearchDomains() {
            if (this.dnsSearchDomains instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dnsSearchDomains;
        }

        public final void setDnsSearchDomains(Collection<String> dnsSearchDomains) {
            this.dnsSearchDomains = StringListCopier.copy(dnsSearchDomains);
        }

        @Override
        public final Builder dnsSearchDomains(Collection<String> dnsSearchDomains) {
            this.dnsSearchDomains = StringListCopier.copy(dnsSearchDomains);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dnsSearchDomains(String ... dnsSearchDomains) {
            this.dnsSearchDomains(Arrays.asList(dnsSearchDomains));
            return this;
        }

        public final List<HostEntry.Builder> getExtraHosts() {
            List<HostEntry.Builder> result = HostEntryListCopier.copyToBuilder(this.extraHosts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExtraHosts(Collection<HostEntry.BuilderImpl> extraHosts) {
            this.extraHosts = HostEntryListCopier.copyFromBuilder(extraHosts);
        }

        @Override
        public final Builder extraHosts(Collection<HostEntry> extraHosts) {
            this.extraHosts = HostEntryListCopier.copy(extraHosts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraHosts(HostEntry ... extraHosts) {
            this.extraHosts(Arrays.asList(extraHosts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder extraHosts(Consumer<HostEntry.Builder> ... extraHosts) {
            this.extraHosts(Stream.of(extraHosts).map(c -> (HostEntry)((HostEntry.Builder)HostEntry.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getDockerSecurityOptions() {
            if (this.dockerSecurityOptions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.dockerSecurityOptions;
        }

        public final void setDockerSecurityOptions(Collection<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = StringListCopier.copy(dockerSecurityOptions);
        }

        @Override
        public final Builder dockerSecurityOptions(Collection<String> dockerSecurityOptions) {
            this.dockerSecurityOptions = StringListCopier.copy(dockerSecurityOptions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dockerSecurityOptions(String ... dockerSecurityOptions) {
            this.dockerSecurityOptions(Arrays.asList(dockerSecurityOptions));
            return this;
        }

        public final Boolean getInteractive() {
            return this.interactive;
        }

        public final void setInteractive(Boolean interactive) {
            this.interactive = interactive;
        }

        @Override
        public final Builder interactive(Boolean interactive) {
            this.interactive = interactive;
            return this;
        }

        public final Boolean getPseudoTerminal() {
            return this.pseudoTerminal;
        }

        public final void setPseudoTerminal(Boolean pseudoTerminal) {
            this.pseudoTerminal = pseudoTerminal;
        }

        @Override
        public final Builder pseudoTerminal(Boolean pseudoTerminal) {
            this.pseudoTerminal = pseudoTerminal;
            return this;
        }

        public final Map<String, String> getDockerLabels() {
            if (this.dockerLabels instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.dockerLabels;
        }

        public final void setDockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = DockerLabelsMapCopier.copy(dockerLabels);
        }

        @Override
        public final Builder dockerLabels(Map<String, String> dockerLabels) {
            this.dockerLabels = DockerLabelsMapCopier.copy(dockerLabels);
            return this;
        }

        public final List<Ulimit.Builder> getUlimits() {
            List<Ulimit.Builder> result = UlimitListCopier.copyToBuilder(this.ulimits);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUlimits(Collection<Ulimit.BuilderImpl> ulimits) {
            this.ulimits = UlimitListCopier.copyFromBuilder(ulimits);
        }

        @Override
        public final Builder ulimits(Collection<Ulimit> ulimits) {
            this.ulimits = UlimitListCopier.copy(ulimits);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Ulimit ... ulimits) {
            this.ulimits(Arrays.asList(ulimits));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ulimits(Consumer<Ulimit.Builder> ... ulimits) {
            this.ulimits(Stream.of(ulimits).map(c -> (Ulimit)((Ulimit.Builder)Ulimit.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final LogConfiguration.Builder getLogConfiguration() {
            return this.logConfiguration != null ? this.logConfiguration.toBuilder() : null;
        }

        public final void setLogConfiguration(LogConfiguration.BuilderImpl logConfiguration) {
            this.logConfiguration = logConfiguration != null ? logConfiguration.build() : null;
        }

        @Override
        public final Builder logConfiguration(LogConfiguration logConfiguration) {
            this.logConfiguration = logConfiguration;
            return this;
        }

        public final HealthCheck.Builder getHealthCheck() {
            return this.healthCheck != null ? this.healthCheck.toBuilder() : null;
        }

        public final void setHealthCheck(HealthCheck.BuilderImpl healthCheck) {
            this.healthCheck = healthCheck != null ? healthCheck.build() : null;
        }

        @Override
        public final Builder healthCheck(HealthCheck healthCheck) {
            this.healthCheck = healthCheck;
            return this;
        }

        public final List<SystemControl.Builder> getSystemControls() {
            List<SystemControl.Builder> result = SystemControlsCopier.copyToBuilder(this.systemControls);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSystemControls(Collection<SystemControl.BuilderImpl> systemControls) {
            this.systemControls = SystemControlsCopier.copyFromBuilder(systemControls);
        }

        @Override
        public final Builder systemControls(Collection<SystemControl> systemControls) {
            this.systemControls = SystemControlsCopier.copy(systemControls);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemControls(SystemControl ... systemControls) {
            this.systemControls(Arrays.asList(systemControls));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder systemControls(Consumer<SystemControl.Builder> ... systemControls) {
            this.systemControls(Stream.of(systemControls).map(c -> (SystemControl)((SystemControl.Builder)SystemControl.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<ResourceRequirement.Builder> getResourceRequirements() {
            List<ResourceRequirement.Builder> result = ResourceRequirementsCopier.copyToBuilder(this.resourceRequirements);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceRequirements(Collection<ResourceRequirement.BuilderImpl> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copyFromBuilder(resourceRequirements);
        }

        @Override
        public final Builder resourceRequirements(Collection<ResourceRequirement> resourceRequirements) {
            this.resourceRequirements = ResourceRequirementsCopier.copy(resourceRequirements);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(ResourceRequirement ... resourceRequirements) {
            this.resourceRequirements(Arrays.asList(resourceRequirements));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... resourceRequirements) {
            this.resourceRequirements(Stream.of(resourceRequirements).map(c -> (ResourceRequirement)((ResourceRequirement.Builder)ResourceRequirement.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final FirelensConfiguration.Builder getFirelensConfiguration() {
            return this.firelensConfiguration != null ? this.firelensConfiguration.toBuilder() : null;
        }

        public final void setFirelensConfiguration(FirelensConfiguration.BuilderImpl firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration != null ? firelensConfiguration.build() : null;
        }

        @Override
        public final Builder firelensConfiguration(FirelensConfiguration firelensConfiguration) {
            this.firelensConfiguration = firelensConfiguration;
            return this;
        }

        public final Collection<String> getCredentialSpecs() {
            if (this.credentialSpecs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.credentialSpecs;
        }

        public final void setCredentialSpecs(Collection<String> credentialSpecs) {
            this.credentialSpecs = StringListCopier.copy(credentialSpecs);
        }

        @Override
        public final Builder credentialSpecs(Collection<String> credentialSpecs) {
            this.credentialSpecs = StringListCopier.copy(credentialSpecs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialSpecs(String ... credentialSpecs) {
            this.credentialSpecs(Arrays.asList(credentialSpecs));
            return this;
        }

        public ContainerDefinition build() {
            return new ContainerDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContainerDefinition> {
        public Builder name(String var1);

        public Builder image(String var1);

        public Builder repositoryCredentials(RepositoryCredentials var1);

        default public Builder repositoryCredentials(Consumer<RepositoryCredentials.Builder> repositoryCredentials) {
            return this.repositoryCredentials((RepositoryCredentials)((RepositoryCredentials.Builder)RepositoryCredentials.builder().applyMutation(repositoryCredentials)).build());
        }

        public Builder cpu(Integer var1);

        public Builder memory(Integer var1);

        public Builder memoryReservation(Integer var1);

        public Builder links(Collection<String> var1);

        public Builder links(String ... var1);

        public Builder portMappings(Collection<PortMapping> var1);

        public Builder portMappings(PortMapping ... var1);

        public Builder portMappings(Consumer<PortMapping.Builder> ... var1);

        public Builder essential(Boolean var1);

        public Builder entryPoint(Collection<String> var1);

        public Builder entryPoint(String ... var1);

        public Builder command(Collection<String> var1);

        public Builder command(String ... var1);

        public Builder environment(Collection<KeyValuePair> var1);

        public Builder environment(KeyValuePair ... var1);

        public Builder environment(Consumer<KeyValuePair.Builder> ... var1);

        public Builder environmentFiles(Collection<EnvironmentFile> var1);

        public Builder environmentFiles(EnvironmentFile ... var1);

        public Builder environmentFiles(Consumer<EnvironmentFile.Builder> ... var1);

        public Builder mountPoints(Collection<MountPoint> var1);

        public Builder mountPoints(MountPoint ... var1);

        public Builder mountPoints(Consumer<MountPoint.Builder> ... var1);

        public Builder volumesFrom(Collection<VolumeFrom> var1);

        public Builder volumesFrom(VolumeFrom ... var1);

        public Builder volumesFrom(Consumer<VolumeFrom.Builder> ... var1);

        public Builder linuxParameters(LinuxParameters var1);

        default public Builder linuxParameters(Consumer<LinuxParameters.Builder> linuxParameters) {
            return this.linuxParameters((LinuxParameters)((LinuxParameters.Builder)LinuxParameters.builder().applyMutation(linuxParameters)).build());
        }

        public Builder secrets(Collection<Secret> var1);

        public Builder secrets(Secret ... var1);

        public Builder secrets(Consumer<Secret.Builder> ... var1);

        public Builder dependsOn(Collection<ContainerDependency> var1);

        public Builder dependsOn(ContainerDependency ... var1);

        public Builder dependsOn(Consumer<ContainerDependency.Builder> ... var1);

        public Builder startTimeout(Integer var1);

        public Builder stopTimeout(Integer var1);

        public Builder hostname(String var1);

        public Builder user(String var1);

        public Builder workingDirectory(String var1);

        public Builder disableNetworking(Boolean var1);

        public Builder privileged(Boolean var1);

        public Builder readonlyRootFilesystem(Boolean var1);

        public Builder dnsServers(Collection<String> var1);

        public Builder dnsServers(String ... var1);

        public Builder dnsSearchDomains(Collection<String> var1);

        public Builder dnsSearchDomains(String ... var1);

        public Builder extraHosts(Collection<HostEntry> var1);

        public Builder extraHosts(HostEntry ... var1);

        public Builder extraHosts(Consumer<HostEntry.Builder> ... var1);

        public Builder dockerSecurityOptions(Collection<String> var1);

        public Builder dockerSecurityOptions(String ... var1);

        public Builder interactive(Boolean var1);

        public Builder pseudoTerminal(Boolean var1);

        public Builder dockerLabels(Map<String, String> var1);

        public Builder ulimits(Collection<Ulimit> var1);

        public Builder ulimits(Ulimit ... var1);

        public Builder ulimits(Consumer<Ulimit.Builder> ... var1);

        public Builder logConfiguration(LogConfiguration var1);

        default public Builder logConfiguration(Consumer<LogConfiguration.Builder> logConfiguration) {
            return this.logConfiguration((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(logConfiguration)).build());
        }

        public Builder healthCheck(HealthCheck var1);

        default public Builder healthCheck(Consumer<HealthCheck.Builder> healthCheck) {
            return this.healthCheck((HealthCheck)((HealthCheck.Builder)HealthCheck.builder().applyMutation(healthCheck)).build());
        }

        public Builder systemControls(Collection<SystemControl> var1);

        public Builder systemControls(SystemControl ... var1);

        public Builder systemControls(Consumer<SystemControl.Builder> ... var1);

        public Builder resourceRequirements(Collection<ResourceRequirement> var1);

        public Builder resourceRequirements(ResourceRequirement ... var1);

        public Builder resourceRequirements(Consumer<ResourceRequirement.Builder> ... var1);

        public Builder firelensConfiguration(FirelensConfiguration var1);

        default public Builder firelensConfiguration(Consumer<FirelensConfiguration.Builder> firelensConfiguration) {
            return this.firelensConfiguration((FirelensConfiguration)((FirelensConfiguration.Builder)FirelensConfiguration.builder().applyMutation(firelensConfiguration)).build());
        }

        public Builder credentialSpecs(Collection<String> var1);

        public Builder credentialSpecs(String ... var1);
    }
}

