/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecs.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecs.model.EcsResponse;
import software.amazon.awssdk.services.ecs.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListServicesByNamespaceResponse
extends EcsResponse
implements ToCopyableBuilder<Builder, ListServicesByNamespaceResponse> {
    private static final SdkField<List<String>> SERVICE_ARNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("serviceArns").getter(ListServicesByNamespaceResponse.getter(ListServicesByNamespaceResponse::serviceArns)).setter(ListServicesByNamespaceResponse.setter(Builder::serviceArns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListServicesByNamespaceResponse.getter(ListServicesByNamespaceResponse::nextToken)).setter(ListServicesByNamespaceResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SERVICE_ARNS_FIELD, NEXT_TOKEN_FIELD));
    private final List<String> serviceArns;
    private final String nextToken;

    private ListServicesByNamespaceResponse(BuilderImpl builder) {
        super(builder);
        this.serviceArns = builder.serviceArns;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasServiceArns() {
        return this.serviceArns != null && !(this.serviceArns instanceof SdkAutoConstructList);
    }

    public final List<String> serviceArns() {
        return this.serviceArns;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasServiceArns() ? this.serviceArns() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListServicesByNamespaceResponse)) {
            return false;
        }
        ListServicesByNamespaceResponse other = (ListServicesByNamespaceResponse)((Object)obj);
        return this.hasServiceArns() == other.hasServiceArns() && Objects.equals(this.serviceArns(), other.serviceArns()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListServicesByNamespaceResponse").add("ServiceArns", this.hasServiceArns() ? this.serviceArns() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "serviceArns": {
                return Optional.ofNullable(clazz.cast(this.serviceArns()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListServicesByNamespaceResponse, T> g) {
        return obj -> g.apply((ListServicesByNamespaceResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcsResponse.BuilderImpl
    implements Builder {
        private List<String> serviceArns = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListServicesByNamespaceResponse model) {
            super(model);
            this.serviceArns(model.serviceArns);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getServiceArns() {
            if (this.serviceArns instanceof SdkAutoConstructList) {
                return null;
            }
            return this.serviceArns;
        }

        public final void setServiceArns(Collection<String> serviceArns) {
            this.serviceArns = StringListCopier.copy(serviceArns);
        }

        @Override
        public final Builder serviceArns(Collection<String> serviceArns) {
            this.serviceArns = StringListCopier.copy(serviceArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder serviceArns(String ... serviceArns) {
            this.serviceArns(Arrays.asList(serviceArns));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListServicesByNamespaceResponse build() {
            return new ListServicesByNamespaceResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcsResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListServicesByNamespaceResponse> {
        public Builder serviceArns(Collection<String> var1);

        public Builder serviceArns(String ... var1);

        public Builder nextToken(String var1);
    }
}

