/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadLayerPartRequest
extends EcrPublicRequest
implements ToCopyableBuilder<Builder, UploadLayerPartRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(UploadLayerPartRequest.getter(UploadLayerPartRequest::registryId)).setter(UploadLayerPartRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(UploadLayerPartRequest.getter(UploadLayerPartRequest::repositoryName)).setter(UploadLayerPartRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(UploadLayerPartRequest.getter(UploadLayerPartRequest::uploadId)).setter(UploadLayerPartRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<Long> PART_FIRST_BYTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("partFirstByte").getter(UploadLayerPartRequest.getter(UploadLayerPartRequest::partFirstByte)).setter(UploadLayerPartRequest.setter(Builder::partFirstByte)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partFirstByte").build()}).build();
    private static final SdkField<Long> PART_LAST_BYTE_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("partLastByte").getter(UploadLayerPartRequest.getter(UploadLayerPartRequest::partLastByte)).setter(UploadLayerPartRequest.setter(Builder::partLastByte)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("partLastByte").build()}).build();
    private static final SdkField<SdkBytes> LAYER_PART_BLOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_BYTES).memberName("layerPartBlob").getter(UploadLayerPartRequest.getter(UploadLayerPartRequest::layerPartBlob)).setter(UploadLayerPartRequest.setter(Builder::layerPartBlob)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layerPartBlob").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, PART_FIRST_BYTE_FIELD, PART_LAST_BYTE_FIELD, LAYER_PART_BLOB_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("registryId", REGISTRY_ID_FIELD);
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("uploadId", UPLOAD_ID_FIELD);
            this.put("partFirstByte", PART_FIRST_BYTE_FIELD);
            this.put("partLastByte", PART_LAST_BYTE_FIELD);
            this.put("layerPartBlob", LAYER_PART_BLOB_FIELD);
        }
    });
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long partFirstByte;
    private final Long partLastByte;
    private final SdkBytes layerPartBlob;

    private UploadLayerPartRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.partFirstByte = builder.partFirstByte;
        this.partLastByte = builder.partLastByte;
        this.layerPartBlob = builder.layerPartBlob;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final Long partFirstByte() {
        return this.partFirstByte;
    }

    public final Long partLastByte() {
        return this.partLastByte;
    }

    public final SdkBytes layerPartBlob() {
        return this.layerPartBlob;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.partFirstByte());
        hashCode = 31 * hashCode + Objects.hashCode(this.partLastByte());
        hashCode = 31 * hashCode + Objects.hashCode(this.layerPartBlob());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartRequest)) {
            return false;
        }
        UploadLayerPartRequest other = (UploadLayerPartRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.partFirstByte(), other.partFirstByte()) && Objects.equals(this.partLastByte(), other.partLastByte()) && Objects.equals(this.layerPartBlob(), other.layerPartBlob());
    }

    public final String toString() {
        return ToString.builder((String)"UploadLayerPartRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("UploadId", (Object)this.uploadId()).add("PartFirstByte", (Object)this.partFirstByte()).add("PartLastByte", (Object)this.partLastByte()).add("LayerPartBlob", (Object)this.layerPartBlob()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "partFirstByte": {
                return Optional.ofNullable(clazz.cast(this.partFirstByte()));
            }
            case "partLastByte": {
                return Optional.ofNullable(clazz.cast(this.partLastByte()));
            }
            case "layerPartBlob": {
                return Optional.ofNullable(clazz.cast(this.layerPartBlob()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<UploadLayerPartRequest, T> g) {
        return obj -> g.apply((UploadLayerPartRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long partFirstByte;
        private Long partLastByte;
        private SdkBytes layerPartBlob;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.partFirstByte(model.partFirstByte);
            this.partLastByte(model.partLastByte);
            this.layerPartBlob(model.layerPartBlob);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final Long getPartFirstByte() {
            return this.partFirstByte;
        }

        public final void setPartFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
        }

        @Override
        public final Builder partFirstByte(Long partFirstByte) {
            this.partFirstByte = partFirstByte;
            return this;
        }

        public final Long getPartLastByte() {
            return this.partLastByte;
        }

        public final void setPartLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
        }

        @Override
        public final Builder partLastByte(Long partLastByte) {
            this.partLastByte = partLastByte;
            return this;
        }

        public final ByteBuffer getLayerPartBlob() {
            return this.layerPartBlob == null ? null : this.layerPartBlob.asByteBuffer();
        }

        public final void setLayerPartBlob(ByteBuffer layerPartBlob) {
            this.layerPartBlob(layerPartBlob == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)layerPartBlob));
        }

        @Override
        public final Builder layerPartBlob(SdkBytes layerPartBlob) {
            this.layerPartBlob = layerPartBlob;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UploadLayerPartRequest build() {
            return new UploadLayerPartRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrPublicRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UploadLayerPartRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder partFirstByte(Long var1);

        public Builder partLastByte(Long var1);

        public Builder layerPartBlob(SdkBytes var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

