/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecrpublic.EcrPublicClient;
import software.amazon.awssdk.services.ecrpublic.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsRequest;
import software.amazon.awssdk.services.ecrpublic.model.DescribeImageTagsResponse;
import software.amazon.awssdk.services.ecrpublic.model.ImageTagDetail;

public class DescribeImageTagsIterable
implements SdkIterable<DescribeImageTagsResponse> {
    private final EcrPublicClient client;
    private final DescribeImageTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeImageTagsIterable(EcrPublicClient client, DescribeImageTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeImageTagsResponseFetcher();
    }

    public Iterator<DescribeImageTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageTagDetail> imageTagDetails() {
        Function<DescribeImageTagsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageTagDetails() != null) {
                return response.imageTagDetails().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeImageTagsResponseFetcher
    implements SyncPageFetcher<DescribeImageTagsResponse> {
        private DescribeImageTagsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeImageTagsResponse nextPage(DescribeImageTagsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageTagsIterable.this.client.describeImageTags(DescribeImageTagsIterable.this.firstRequest);
            }
            return DescribeImageTagsIterable.this.client.describeImageTags((DescribeImageTagsRequest)((Object)DescribeImageTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

