/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.beans.Transient;
import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthorizationData
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthorizationData> {
    private static final SdkField<String> AUTHORIZATION_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("authorizationToken").getter(AuthorizationData.getter(AuthorizationData::authorizationToken)).setter(AuthorizationData.setter(Builder::authorizationToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationToken").build()}).build();
    private static final SdkField<Instant> EXPIRES_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("expiresAt").getter(AuthorizationData.getter(AuthorizationData::expiresAt)).setter(AuthorizationData.setter(Builder::expiresAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiresAt").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TOKEN_FIELD, EXPIRES_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final String authorizationToken;
    private final Instant expiresAt;

    private AuthorizationData(BuilderImpl builder) {
        this.authorizationToken = builder.authorizationToken;
        this.expiresAt = builder.expiresAt;
    }

    public final String authorizationToken() {
        return this.authorizationToken;
    }

    public final Instant expiresAt() {
        return this.expiresAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.expiresAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationData)) {
            return false;
        }
        AuthorizationData other = (AuthorizationData)obj;
        return Objects.equals(this.authorizationToken(), other.authorizationToken()) && Objects.equals(this.expiresAt(), other.expiresAt());
    }

    public final String toString() {
        return ToString.builder((String)"AuthorizationData").add("AuthorizationToken", (Object)this.authorizationToken()).add("ExpiresAt", (Object)this.expiresAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationToken": {
                return Optional.ofNullable(clazz.cast(this.authorizationToken()));
            }
            case "expiresAt": {
                return Optional.ofNullable(clazz.cast(this.expiresAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationData, T> g) {
        return obj -> g.apply((AuthorizationData)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String authorizationToken;
        private Instant expiresAt;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationData model) {
            this.authorizationToken(model.authorizationToken);
            this.expiresAt(model.expiresAt);
        }

        public final String getAuthorizationToken() {
            return this.authorizationToken;
        }

        public final void setAuthorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
        }

        @Override
        @Transient
        public final Builder authorizationToken(String authorizationToken) {
            this.authorizationToken = authorizationToken;
            return this;
        }

        public final Instant getExpiresAt() {
            return this.expiresAt;
        }

        public final void setExpiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
        }

        @Override
        @Transient
        public final Builder expiresAt(Instant expiresAt) {
            this.expiresAt = expiresAt;
            return this;
        }

        public AuthorizationData build() {
            return new AuthorizationData(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthorizationData> {
        public Builder authorizationToken(String var1);

        public Builder expiresAt(Instant var1);
    }
}

