/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecrpublic.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecrpublic.model.EcrPublicResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UploadLayerPartResponse
extends EcrPublicResponse
implements ToCopyableBuilder<Builder, UploadLayerPartResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(UploadLayerPartResponse.getter(UploadLayerPartResponse::registryId)).setter(UploadLayerPartResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(UploadLayerPartResponse.getter(UploadLayerPartResponse::repositoryName)).setter(UploadLayerPartResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("uploadId").getter(UploadLayerPartResponse.getter(UploadLayerPartResponse::uploadId)).setter(UploadLayerPartResponse.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uploadId").build()}).build();
    private static final SdkField<Long> LAST_BYTE_RECEIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("lastByteReceived").getter(UploadLayerPartResponse.getter(UploadLayerPartResponse::lastByteReceived)).setter(UploadLayerPartResponse.setter(Builder::lastByteReceived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastByteReceived").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, UPLOAD_ID_FIELD, LAST_BYTE_RECEIVED_FIELD));
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long lastByteReceived;

    private UploadLayerPartResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastByteReceived = builder.lastByteReceived;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final Long lastByteReceived() {
        return this.lastByteReceived;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastByteReceived());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartResponse)) {
            return false;
        }
        UploadLayerPartResponse other = (UploadLayerPartResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.lastByteReceived(), other.lastByteReceived());
    }

    public final String toString() {
        return ToString.builder((String)"UploadLayerPartResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("UploadId", (Object)this.uploadId()).add("LastByteReceived", (Object)this.lastByteReceived()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "uploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "lastByteReceived": {
                return Optional.ofNullable(clazz.cast(this.lastByteReceived()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UploadLayerPartResponse, T> g) {
        return obj -> g.apply((UploadLayerPartResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrPublicResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long lastByteReceived;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.lastByteReceived(model.lastByteReceived);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getLastByteReceived() {
            return this.lastByteReceived;
        }

        @Override
        public final Builder lastByteReceived(Long lastByteReceived) {
            this.lastByteReceived = lastByteReceived;
            return this;
        }

        public final void setLastByteReceived(Long lastByteReceived) {
            this.lastByteReceived = lastByteReceived;
        }

        @Override
        public UploadLayerPartResponse build() {
            return new UploadLayerPartResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrPublicResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UploadLayerPartResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder lastByteReceived(Long var1);
    }
}

