/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResult;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewResultListCopier;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewStatus;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetLifecyclePolicyPreviewResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, GetLifecyclePolicyPreviewResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::registryId)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::repositoryName)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> LIFECYCLE_POLICY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::lifecyclePolicyText)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::lifecyclePolicyText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyText").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::statusAsString)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::nextToken)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<LifecyclePolicyPreviewResult>> PREVIEW_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::previewResults)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::previewResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("previewResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LifecyclePolicyPreviewResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<LifecyclePolicyPreviewSummary> SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(GetLifecyclePolicyPreviewResponse.getter(GetLifecyclePolicyPreviewResponse::summary)).setter(GetLifecyclePolicyPreviewResponse.setter(Builder::summary)).constructor(LifecyclePolicyPreviewSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("summary").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, LIFECYCLE_POLICY_TEXT_FIELD, STATUS_FIELD, NEXT_TOKEN_FIELD, PREVIEW_RESULTS_FIELD, SUMMARY_FIELD));
    private final String registryId;
    private final String repositoryName;
    private final String lifecyclePolicyText;
    private final String status;
    private final String nextToken;
    private final List<LifecyclePolicyPreviewResult> previewResults;
    private final LifecyclePolicyPreviewSummary summary;

    private GetLifecyclePolicyPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.status = builder.status;
        this.nextToken = builder.nextToken;
        this.previewResults = builder.previewResults;
        this.summary = builder.summary;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String lifecyclePolicyText() {
        return this.lifecyclePolicyText;
    }

    public LifecyclePolicyPreviewStatus status() {
        return LifecyclePolicyPreviewStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<LifecyclePolicyPreviewResult> previewResults() {
        return this.previewResults;
    }

    public LifecyclePolicyPreviewSummary summary() {
        return this.summary;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.previewResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.summary());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLifecyclePolicyPreviewResponse)) {
            return false;
        }
        GetLifecyclePolicyPreviewResponse other = (GetLifecyclePolicyPreviewResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.lifecyclePolicyText(), other.lifecyclePolicyText()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.previewResults(), other.previewResults()) && Objects.equals(this.summary(), other.summary());
    }

    public String toString() {
        return ToString.builder((String)"GetLifecyclePolicyPreviewResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("LifecyclePolicyText", (Object)this.lifecyclePolicyText()).add("Status", (Object)this.statusAsString()).add("NextToken", (Object)this.nextToken()).add("PreviewResults", this.previewResults()).add("Summary", (Object)this.summary()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "lifecyclePolicyText": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyText()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "previewResults": {
                return Optional.ofNullable(clazz.cast(this.previewResults()));
            }
            case "summary": {
                return Optional.ofNullable(clazz.cast(this.summary()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetLifecyclePolicyPreviewResponse, T> g) {
        return obj -> g.apply((GetLifecyclePolicyPreviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String lifecyclePolicyText;
        private String status;
        private String nextToken;
        private List<LifecyclePolicyPreviewResult> previewResults = DefaultSdkAutoConstructList.getInstance();
        private LifecyclePolicyPreviewSummary summary;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLifecyclePolicyPreviewResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.lifecyclePolicyText(model.lifecyclePolicyText);
            this.status(model.status);
            this.nextToken(model.nextToken);
            this.previewResults(model.previewResults);
            this.summary(model.summary);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getLifecyclePolicyText() {
            return this.lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyPreviewStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<LifecyclePolicyPreviewResult.Builder> getPreviewResults() {
            return this.previewResults != null ? (Collection)this.previewResults.stream().map(LifecyclePolicyPreviewResult::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder previewResults(Collection<LifecyclePolicyPreviewResult> previewResults) {
            this.previewResults = LifecyclePolicyPreviewResultListCopier.copy(previewResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(LifecyclePolicyPreviewResult ... previewResults) {
            this.previewResults(Arrays.asList(previewResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder previewResults(Consumer<LifecyclePolicyPreviewResult.Builder> ... previewResults) {
            this.previewResults(Stream.of(previewResults).map(c -> (LifecyclePolicyPreviewResult)((LifecyclePolicyPreviewResult.Builder)LifecyclePolicyPreviewResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setPreviewResults(Collection<LifecyclePolicyPreviewResult.BuilderImpl> previewResults) {
            this.previewResults = LifecyclePolicyPreviewResultListCopier.copyFromBuilder(previewResults);
        }

        public final LifecyclePolicyPreviewSummary.Builder getSummary() {
            return this.summary != null ? this.summary.toBuilder() : null;
        }

        @Override
        public final Builder summary(LifecyclePolicyPreviewSummary summary) {
            this.summary = summary;
            return this;
        }

        public final void setSummary(LifecyclePolicyPreviewSummary.BuilderImpl summary) {
            this.summary = summary != null ? summary.build() : null;
        }

        @Override
        public GetLifecyclePolicyPreviewResponse build() {
            return new GetLifecyclePolicyPreviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetLifecyclePolicyPreviewResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder lifecyclePolicyText(String var1);

        public Builder status(String var1);

        public Builder status(LifecyclePolicyPreviewStatus var1);

        public Builder nextToken(String var1);

        public Builder previewResults(Collection<LifecyclePolicyPreviewResult> var1);

        public Builder previewResults(LifecyclePolicyPreviewResult ... var1);

        public Builder previewResults(Consumer<LifecyclePolicyPreviewResult.Builder> ... var1);

        public Builder summary(LifecyclePolicyPreviewSummary var1);

        default public Builder summary(Consumer<LifecyclePolicyPreviewSummary.Builder> summary) {
            return this.summary((LifecyclePolicyPreviewSummary)((LifecyclePolicyPreviewSummary.Builder)LifecyclePolicyPreviewSummary.builder().applyMutation(summary)).build());
        }
    }
}

