/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.ArtifactStatusFilter;
import software.amazon.awssdk.services.ecr.model.ArtifactTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImageReferrersFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListImageReferrersFilter> {
    private static final SdkField<List<String>> ARTIFACT_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("artifactTypes").getter(ListImageReferrersFilter.getter(ListImageReferrersFilter::artifactTypes)).setter(ListImageReferrersFilter.setter(Builder::artifactTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARTIFACT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("artifactStatus").getter(ListImageReferrersFilter.getter(ListImageReferrersFilter::artifactStatusAsString)).setter(ListImageReferrersFilter.setter(Builder::artifactStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("artifactStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARTIFACT_TYPES_FIELD, ARTIFACT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListImageReferrersFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> artifactTypes;
    private final String artifactStatus;

    private ListImageReferrersFilter(BuilderImpl builder) {
        this.artifactTypes = builder.artifactTypes;
        this.artifactStatus = builder.artifactStatus;
    }

    public final boolean hasArtifactTypes() {
        return this.artifactTypes != null && !(this.artifactTypes instanceof SdkAutoConstructList);
    }

    public final List<String> artifactTypes() {
        return this.artifactTypes;
    }

    public final ArtifactStatusFilter artifactStatus() {
        return ArtifactStatusFilter.fromValue(this.artifactStatus);
    }

    public final String artifactStatusAsString() {
        return this.artifactStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArtifactTypes() ? this.artifactTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.artifactStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageReferrersFilter)) {
            return false;
        }
        ListImageReferrersFilter other = (ListImageReferrersFilter)obj;
        return this.hasArtifactTypes() == other.hasArtifactTypes() && Objects.equals(this.artifactTypes(), other.artifactTypes()) && Objects.equals(this.artifactStatusAsString(), other.artifactStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListImageReferrersFilter").add("ArtifactTypes", this.hasArtifactTypes() ? this.artifactTypes() : null).add("ArtifactStatus", (Object)this.artifactStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "artifactTypes": {
                return Optional.ofNullable(clazz.cast(this.artifactTypes()));
            }
            case "artifactStatus": {
                return Optional.ofNullable(clazz.cast(this.artifactStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("artifactTypes", ARTIFACT_TYPES_FIELD);
        map.put("artifactStatus", ARTIFACT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImageReferrersFilter, T> g) {
        return obj -> g.apply((ListImageReferrersFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> artifactTypes = DefaultSdkAutoConstructList.getInstance();
        private String artifactStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageReferrersFilter model) {
            this.artifactTypes(model.artifactTypes);
            this.artifactStatus(model.artifactStatus);
        }

        public final Collection<String> getArtifactTypes() {
            if (this.artifactTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.artifactTypes;
        }

        public final void setArtifactTypes(Collection<String> artifactTypes) {
            this.artifactTypes = ArtifactTypeListCopier.copy(artifactTypes);
        }

        @Override
        public final Builder artifactTypes(Collection<String> artifactTypes) {
            this.artifactTypes = ArtifactTypeListCopier.copy(artifactTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder artifactTypes(String ... artifactTypes) {
            this.artifactTypes(Arrays.asList(artifactTypes));
            return this;
        }

        public final String getArtifactStatus() {
            return this.artifactStatus;
        }

        public final void setArtifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
        }

        @Override
        public final Builder artifactStatus(String artifactStatus) {
            this.artifactStatus = artifactStatus;
            return this;
        }

        @Override
        public final Builder artifactStatus(ArtifactStatusFilter artifactStatus) {
            this.artifactStatus(artifactStatus == null ? null : artifactStatus.toString());
            return this;
        }

        public ListImageReferrersFilter build() {
            return new ListImageReferrersFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListImageReferrersFilter> {
        public Builder artifactTypes(Collection<String> var1);

        public Builder artifactTypes(String ... var1);

        public Builder artifactStatus(String var1);

        public Builder artifactStatus(ArtifactStatusFilter var1);
    }
}

