/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageSigningStatus;
import software.amazon.awssdk.services.ecr.model.ImageSigningStatusListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageSigningStatusResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DescribeImageSigningStatusResponse> {
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(DescribeImageSigningStatusResponse.getter(DescribeImageSigningStatusResponse::repositoryName)).setter(DescribeImageSigningStatusResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageId").getter(DescribeImageSigningStatusResponse.getter(DescribeImageSigningStatusResponse::imageId)).setter(DescribeImageSigningStatusResponse.setter(Builder::imageId)).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DescribeImageSigningStatusResponse.getter(DescribeImageSigningStatusResponse::registryId)).setter(DescribeImageSigningStatusResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<List<ImageSigningStatus>> SIGNING_STATUSES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("signingStatuses").getter(DescribeImageSigningStatusResponse.getter(DescribeImageSigningStatusResponse::signingStatuses)).setter(DescribeImageSigningStatusResponse.setter(Builder::signingStatuses)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingStatuses").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageSigningStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, REGISTRY_ID_FIELD, SIGNING_STATUSES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeImageSigningStatusResponse.memberNameToFieldInitializer();
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final String registryId;
    private final List<ImageSigningStatus> signingStatuses;

    private DescribeImageSigningStatusResponse(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.registryId = builder.registryId;
        this.signingStatuses = builder.signingStatuses;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ImageIdentifier imageId() {
        return this.imageId;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final boolean hasSigningStatuses() {
        return this.signingStatuses != null && !(this.signingStatuses instanceof SdkAutoConstructList);
    }

    public final List<ImageSigningStatus> signingStatuses() {
        return this.signingStatuses;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSigningStatuses() ? this.signingStatuses() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageSigningStatusResponse)) {
            return false;
        }
        DescribeImageSigningStatusResponse other = (DescribeImageSigningStatusResponse)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.registryId(), other.registryId()) && this.hasSigningStatuses() == other.hasSigningStatuses() && Objects.equals(this.signingStatuses(), other.signingStatuses());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageSigningStatusResponse").add("RepositoryName", (Object)this.repositoryName()).add("ImageId", (Object)this.imageId()).add("RegistryId", (Object)this.registryId()).add("SigningStatuses", this.hasSigningStatuses() ? this.signingStatuses() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "signingStatuses": {
                return Optional.ofNullable(clazz.cast(this.signingStatuses()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("signingStatuses", SIGNING_STATUSES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageSigningStatusResponse, T> g) {
        return obj -> g.apply((DescribeImageSigningStatusResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String repositoryName;
        private ImageIdentifier imageId;
        private String registryId;
        private List<ImageSigningStatus> signingStatuses = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageSigningStatusResponse model) {
            super(model);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.registryId(model.registryId);
            this.signingStatuses(model.signingStatuses);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final List<ImageSigningStatus.Builder> getSigningStatuses() {
            List<ImageSigningStatus.Builder> result = ImageSigningStatusListCopier.copyToBuilder(this.signingStatuses);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSigningStatuses(Collection<ImageSigningStatus.BuilderImpl> signingStatuses) {
            this.signingStatuses = ImageSigningStatusListCopier.copyFromBuilder(signingStatuses);
        }

        @Override
        public final Builder signingStatuses(Collection<ImageSigningStatus> signingStatuses) {
            this.signingStatuses = ImageSigningStatusListCopier.copy(signingStatuses);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingStatuses(ImageSigningStatus ... signingStatuses) {
            this.signingStatuses(Arrays.asList(signingStatuses));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder signingStatuses(Consumer<ImageSigningStatus.Builder> ... signingStatuses) {
            this.signingStatuses(Stream.of(signingStatuses).map(c -> (ImageSigningStatus)((ImageSigningStatus.Builder)ImageSigningStatus.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeImageSigningStatusResponse build() {
            return new DescribeImageSigningStatusResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageSigningStatusResponse> {
        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation(imageId)).build());
        }

        public Builder registryId(String var1);

        public Builder signingStatuses(Collection<ImageSigningStatus> var1);

        public Builder signingStatuses(ImageSigningStatus ... var1);

        public Builder signingStatuses(Consumer<ImageSigningStatus.Builder> ... var1);
    }
}

