/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The total count of images transitioning to a storage class.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransitioningImageTotalCount implements SdkPojo, Serializable,
        ToCopyableBuilder<TransitioningImageTotalCount.Builder, TransitioningImageTotalCount> {
    private static final SdkField<String> TARGET_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetStorageClass").getter(getter(TransitioningImageTotalCount::targetStorageClassAsString))
            .setter(setter(Builder::targetStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStorageClass").build())
            .build();

    private static final SdkField<Integer> IMAGE_TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("imageTotalCount").getter(getter(TransitioningImageTotalCount::imageTotalCount))
            .setter(setter(Builder::imageTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTotalCount").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TARGET_STORAGE_CLASS_FIELD,
            IMAGE_TOTAL_COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String targetStorageClass;

    private final Integer imageTotalCount;

    private TransitioningImageTotalCount(BuilderImpl builder) {
        this.targetStorageClass = builder.targetStorageClass;
        this.imageTotalCount = builder.imageTotalCount;
    }

    /**
     * <p>
     * The target storage class.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetStorageClass} will return {@link LifecyclePolicyTargetStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetStorageClassAsString}.
     * </p>
     * 
     * @return The target storage class.
     * @see LifecyclePolicyTargetStorageClass
     */
    public final LifecyclePolicyTargetStorageClass targetStorageClass() {
        return LifecyclePolicyTargetStorageClass.fromValue(targetStorageClass);
    }

    /**
     * <p>
     * The target storage class.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetStorageClass} will return {@link LifecyclePolicyTargetStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetStorageClassAsString}.
     * </p>
     * 
     * @return The target storage class.
     * @see LifecyclePolicyTargetStorageClass
     */
    public final String targetStorageClassAsString() {
        return targetStorageClass;
    }

    /**
     * <p>
     * The total number of images transitioning to the storage class.
     * </p>
     * 
     * @return The total number of images transitioning to the storage class.
     */
    public final Integer imageTotalCount() {
        return imageTotalCount;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(targetStorageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(imageTotalCount());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransitioningImageTotalCount)) {
            return false;
        }
        TransitioningImageTotalCount other = (TransitioningImageTotalCount) obj;
        return Objects.equals(targetStorageClassAsString(), other.targetStorageClassAsString())
                && Objects.equals(imageTotalCount(), other.imageTotalCount());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransitioningImageTotalCount").add("TargetStorageClass", targetStorageClassAsString())
                .add("ImageTotalCount", imageTotalCount()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "targetStorageClass":
            return Optional.ofNullable(clazz.cast(targetStorageClassAsString()));
        case "imageTotalCount":
            return Optional.ofNullable(clazz.cast(imageTotalCount()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("targetStorageClass", TARGET_STORAGE_CLASS_FIELD);
        map.put("imageTotalCount", IMAGE_TOTAL_COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransitioningImageTotalCount, T> g) {
        return obj -> g.apply((TransitioningImageTotalCount) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransitioningImageTotalCount> {
        /**
         * <p>
         * The target storage class.
         * </p>
         * 
         * @param targetStorageClass
         *        The target storage class.
         * @see LifecyclePolicyTargetStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyTargetStorageClass
         */
        Builder targetStorageClass(String targetStorageClass);

        /**
         * <p>
         * The target storage class.
         * </p>
         * 
         * @param targetStorageClass
         *        The target storage class.
         * @see LifecyclePolicyTargetStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LifecyclePolicyTargetStorageClass
         */
        Builder targetStorageClass(LifecyclePolicyTargetStorageClass targetStorageClass);

        /**
         * <p>
         * The total number of images transitioning to the storage class.
         * </p>
         * 
         * @param imageTotalCount
         *        The total number of images transitioning to the storage class.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageTotalCount(Integer imageTotalCount);
    }

    static final class BuilderImpl implements Builder {
        private String targetStorageClass;

        private Integer imageTotalCount;

        private BuilderImpl() {
        }

        private BuilderImpl(TransitioningImageTotalCount model) {
            targetStorageClass(model.targetStorageClass);
            imageTotalCount(model.imageTotalCount);
        }

        public final String getTargetStorageClass() {
            return targetStorageClass;
        }

        public final void setTargetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
        }

        @Override
        public final Builder targetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
            return this;
        }

        @Override
        public final Builder targetStorageClass(LifecyclePolicyTargetStorageClass targetStorageClass) {
            this.targetStorageClass(targetStorageClass == null ? null : targetStorageClass.toString());
            return this;
        }

        public final Integer getImageTotalCount() {
            return imageTotalCount;
        }

        public final void setImageTotalCount(Integer imageTotalCount) {
            this.imageTotalCount = imageTotalCount;
        }

        @Override
        public final Builder imageTotalCount(Integer imageTotalCount) {
            this.imageTotalCount = imageTotalCount;
            return this;
        }

        @Override
        public TransitioningImageTotalCount build() {
            return new TransitioningImageTotalCount(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
