/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The signing configuration for a registry, which specifies rules for automatically signing images when pushed.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningConfiguration.Builder, SigningConfiguration> {
    private static final SdkField<List<SigningRule>> RULES_FIELD = SdkField
            .<List<SigningRule>> builder(MarshallingType.LIST)
            .memberName("rules")
            .getter(getter(SigningConfiguration::rules))
            .setter(setter(Builder::rules))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SigningRule> builder(MarshallingType.SDK_POJO)
                                            .constructor(SigningRule::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RULES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<SigningRule> rules;

    private SigningConfiguration(BuilderImpl builder) {
        this.rules = builder.rules;
    }

    /**
     * For responses, this returns true if the service returned a value for the Rules property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasRules() {
        return rules != null && !(rules instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of signing rules. Each rule defines a signing profile and optional repository filters that determine which
     * images are automatically signed. Maximum of 10 rules.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRules} method.
     * </p>
     * 
     * @return A list of signing rules. Each rule defines a signing profile and optional repository filters that
     *         determine which images are automatically signed. Maximum of 10 rules.
     */
    public final List<SigningRule> rules() {
        return rules;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasRules() ? rules() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningConfiguration)) {
            return false;
        }
        SigningConfiguration other = (SigningConfiguration) obj;
        return hasRules() == other.hasRules() && Objects.equals(rules(), other.rules());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningConfiguration").add("Rules", hasRules() ? rules() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "rules":
            return Optional.ofNullable(clazz.cast(rules()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("rules", RULES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SigningConfiguration, T> g) {
        return obj -> g.apply((SigningConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningConfiguration> {
        /**
         * <p>
         * A list of signing rules. Each rule defines a signing profile and optional repository filters that determine
         * which images are automatically signed. Maximum of 10 rules.
         * </p>
         * 
         * @param rules
         *        A list of signing rules. Each rule defines a signing profile and optional repository filters that
         *        determine which images are automatically signed. Maximum of 10 rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(Collection<SigningRule> rules);

        /**
         * <p>
         * A list of signing rules. Each rule defines a signing profile and optional repository filters that determine
         * which images are automatically signed. Maximum of 10 rules.
         * </p>
         * 
         * @param rules
         *        A list of signing rules. Each rule defines a signing profile and optional repository filters that
         *        determine which images are automatically signed. Maximum of 10 rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rules(SigningRule... rules);

        /**
         * <p>
         * A list of signing rules. Each rule defines a signing profile and optional repository filters that determine
         * which images are automatically signed. Maximum of 10 rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.SigningRule.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.ecr.model.SigningRule#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.SigningRule.Builder#build()} is called immediately and its
         * result is passed to {@link #rules(List<SigningRule>)}.
         * 
         * @param rules
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.SigningRule.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rules(java.util.Collection<SigningRule>)
         */
        Builder rules(Consumer<SigningRule.Builder>... rules);
    }

    static final class BuilderImpl implements Builder {
        private List<SigningRule> rules = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SigningConfiguration model) {
            rules(model.rules);
        }

        public final List<SigningRule.Builder> getRules() {
            List<SigningRule.Builder> result = SigningRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<SigningRule.BuilderImpl> rules) {
            this.rules = SigningRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        public final Builder rules(Collection<SigningRule> rules) {
            this.rules = SigningRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(SigningRule... rules) {
            rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rules(Consumer<SigningRule.Builder>... rules) {
            rules(Stream.of(rules).map(c -> SigningRule.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public SigningConfiguration build() {
            return new SigningConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
