/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The summary of the lifecycle policy preview request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LifecyclePolicyPreviewSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LifecyclePolicyPreviewSummary.Builder, LifecyclePolicyPreviewSummary> {
    private static final SdkField<Integer> EXPIRING_IMAGE_TOTAL_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("expiringImageTotalCount").getter(getter(LifecyclePolicyPreviewSummary::expiringImageTotalCount))
            .setter(setter(Builder::expiringImageTotalCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("expiringImageTotalCount").build())
            .build();

    private static final SdkField<List<TransitioningImageTotalCount>> TRANSITIONING_IMAGE_TOTAL_COUNTS_FIELD = SdkField
            .<List<TransitioningImageTotalCount>> builder(MarshallingType.LIST)
            .memberName("transitioningImageTotalCounts")
            .getter(getter(LifecyclePolicyPreviewSummary::transitioningImageTotalCounts))
            .setter(setter(Builder::transitioningImageTotalCounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transitioningImageTotalCounts")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TransitioningImageTotalCount> builder(MarshallingType.SDK_POJO)
                                            .constructor(TransitioningImageTotalCount::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            EXPIRING_IMAGE_TOTAL_COUNT_FIELD, TRANSITIONING_IMAGE_TOTAL_COUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer expiringImageTotalCount;

    private final List<TransitioningImageTotalCount> transitioningImageTotalCounts;

    private LifecyclePolicyPreviewSummary(BuilderImpl builder) {
        this.expiringImageTotalCount = builder.expiringImageTotalCount;
        this.transitioningImageTotalCounts = builder.transitioningImageTotalCounts;
    }

    /**
     * <p>
     * The number of expiring images.
     * </p>
     * 
     * @return The number of expiring images.
     */
    public final Integer expiringImageTotalCount() {
        return expiringImageTotalCount;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransitioningImageTotalCounts property.
     * This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransitioningImageTotalCounts() {
        return transitioningImageTotalCounts != null && !(transitioningImageTotalCounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The total count of images that will be transitioned to each storage class. This field is only present if at least
     * one image will be transitoned in the summary.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransitioningImageTotalCounts} method.
     * </p>
     * 
     * @return The total count of images that will be transitioned to each storage class. This field is only present if
     *         at least one image will be transitoned in the summary.
     */
    public final List<TransitioningImageTotalCount> transitioningImageTotalCounts() {
        return transitioningImageTotalCounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(expiringImageTotalCount());
        hashCode = 31 * hashCode + Objects.hashCode(hasTransitioningImageTotalCounts() ? transitioningImageTotalCounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyPreviewSummary)) {
            return false;
        }
        LifecyclePolicyPreviewSummary other = (LifecyclePolicyPreviewSummary) obj;
        return Objects.equals(expiringImageTotalCount(), other.expiringImageTotalCount())
                && hasTransitioningImageTotalCounts() == other.hasTransitioningImageTotalCounts()
                && Objects.equals(transitioningImageTotalCounts(), other.transitioningImageTotalCounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("LifecyclePolicyPreviewSummary")
                .add("ExpiringImageTotalCount", expiringImageTotalCount())
                .add("TransitioningImageTotalCounts", hasTransitioningImageTotalCounts() ? transitioningImageTotalCounts() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "expiringImageTotalCount":
            return Optional.ofNullable(clazz.cast(expiringImageTotalCount()));
        case "transitioningImageTotalCounts":
            return Optional.ofNullable(clazz.cast(transitioningImageTotalCounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("expiringImageTotalCount", EXPIRING_IMAGE_TOTAL_COUNT_FIELD);
        map.put("transitioningImageTotalCounts", TRANSITIONING_IMAGE_TOTAL_COUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyPreviewSummary, T> g) {
        return obj -> g.apply((LifecyclePolicyPreviewSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LifecyclePolicyPreviewSummary> {
        /**
         * <p>
         * The number of expiring images.
         * </p>
         * 
         * @param expiringImageTotalCount
         *        The number of expiring images.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expiringImageTotalCount(Integer expiringImageTotalCount);

        /**
         * <p>
         * The total count of images that will be transitioned to each storage class. This field is only present if at
         * least one image will be transitoned in the summary.
         * </p>
         * 
         * @param transitioningImageTotalCounts
         *        The total count of images that will be transitioned to each storage class. This field is only present
         *        if at least one image will be transitoned in the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitioningImageTotalCounts(Collection<TransitioningImageTotalCount> transitioningImageTotalCounts);

        /**
         * <p>
         * The total count of images that will be transitioned to each storage class. This field is only present if at
         * least one image will be transitoned in the summary.
         * </p>
         * 
         * @param transitioningImageTotalCounts
         *        The total count of images that will be transitioned to each storage class. This field is only present
         *        if at least one image will be transitoned in the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transitioningImageTotalCounts(TransitioningImageTotalCount... transitioningImageTotalCounts);

        /**
         * <p>
         * The total count of images that will be transitioned to each storage class. This field is only present if at
         * least one image will be transitoned in the summary.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.ecr.model.TransitioningImageTotalCount.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.ecr.model.TransitioningImageTotalCount#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.ecr.model.TransitioningImageTotalCount.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #transitioningImageTotalCounts(List<TransitioningImageTotalCount>)}.
         * 
         * @param transitioningImageTotalCounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.ecr.model.TransitioningImageTotalCount.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transitioningImageTotalCounts(java.util.Collection<TransitioningImageTotalCount>)
         */
        Builder transitioningImageTotalCounts(Consumer<TransitioningImageTotalCount.Builder>... transitioningImageTotalCounts);
    }

    static final class BuilderImpl implements Builder {
        private Integer expiringImageTotalCount;

        private List<TransitioningImageTotalCount> transitioningImageTotalCounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyPreviewSummary model) {
            expiringImageTotalCount(model.expiringImageTotalCount);
            transitioningImageTotalCounts(model.transitioningImageTotalCounts);
        }

        public final Integer getExpiringImageTotalCount() {
            return expiringImageTotalCount;
        }

        public final void setExpiringImageTotalCount(Integer expiringImageTotalCount) {
            this.expiringImageTotalCount = expiringImageTotalCount;
        }

        @Override
        public final Builder expiringImageTotalCount(Integer expiringImageTotalCount) {
            this.expiringImageTotalCount = expiringImageTotalCount;
            return this;
        }

        public final List<TransitioningImageTotalCount.Builder> getTransitioningImageTotalCounts() {
            List<TransitioningImageTotalCount.Builder> result = TransitioningImageTotalCountsCopier
                    .copyToBuilder(this.transitioningImageTotalCounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTransitioningImageTotalCounts(
                Collection<TransitioningImageTotalCount.BuilderImpl> transitioningImageTotalCounts) {
            this.transitioningImageTotalCounts = TransitioningImageTotalCountsCopier
                    .copyFromBuilder(transitioningImageTotalCounts);
        }

        @Override
        public final Builder transitioningImageTotalCounts(Collection<TransitioningImageTotalCount> transitioningImageTotalCounts) {
            this.transitioningImageTotalCounts = TransitioningImageTotalCountsCopier.copy(transitioningImageTotalCounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitioningImageTotalCounts(TransitioningImageTotalCount... transitioningImageTotalCounts) {
            transitioningImageTotalCounts(Arrays.asList(transitioningImageTotalCounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transitioningImageTotalCounts(
                Consumer<TransitioningImageTotalCount.Builder>... transitioningImageTotalCounts) {
            transitioningImageTotalCounts(Stream.of(transitioningImageTotalCounts)
                    .map(c -> TransitioningImageTotalCount.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public LifecyclePolicyPreviewSummary build() {
            return new LifecyclePolicyPreviewSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
