/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateImageStorageClassRequest extends EcrRequest implements
        ToCopyableBuilder<UpdateImageStorageClassRequest.Builder, UpdateImageStorageClassRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(UpdateImageStorageClassRequest::registryId))
            .setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(UpdateImageStorageClassRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.<ImageIdentifier> builder(MarshallingType.SDK_POJO)
            .memberName("imageId").getter(getter(UpdateImageStorageClassRequest::imageId)).setter(setter(Builder::imageId))
            .constructor(ImageIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()).build();

    private static final SdkField<String> TARGET_STORAGE_CLASS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetStorageClass").getter(getter(UpdateImageStorageClassRequest::targetStorageClassAsString))
            .setter(setter(Builder::targetStorageClass))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStorageClass").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, TARGET_STORAGE_CLASS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final ImageIdentifier imageId;

    private final String targetStorageClass;

    private UpdateImageStorageClassRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.targetStorageClass = builder.targetStorageClass;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry that contains the image to transition. If you do
     * not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry that contains the image to transition. If
     *         you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository that contains the image to transition.
     * </p>
     * 
     * @return The name of the repository that contains the image to transition.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * Returns the value of the ImageId property for this object.
     * 
     * @return The value of the ImageId property for this object.
     */
    public final ImageIdentifier imageId() {
        return imageId;
    }

    /**
     * <p>
     * The target storage class for the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetStorageClass} will return {@link TargetStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #targetStorageClassAsString}.
     * </p>
     * 
     * @return The target storage class for the image.
     * @see TargetStorageClass
     */
    public final TargetStorageClass targetStorageClass() {
        return TargetStorageClass.fromValue(targetStorageClass);
    }

    /**
     * <p>
     * The target storage class for the image.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetStorageClass} will return {@link TargetStorageClass#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #targetStorageClassAsString}.
     * </p>
     * 
     * @return The target storage class for the image.
     * @see TargetStorageClass
     */
    public final String targetStorageClassAsString() {
        return targetStorageClass;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(imageId());
        hashCode = 31 * hashCode + Objects.hashCode(targetStorageClassAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateImageStorageClassRequest)) {
            return false;
        }
        UpdateImageStorageClassRequest other = (UpdateImageStorageClassRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(imageId(), other.imageId())
                && Objects.equals(targetStorageClassAsString(), other.targetStorageClassAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateImageStorageClassRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("ImageId", imageId())
                .add("TargetStorageClass", targetStorageClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "imageId":
            return Optional.ofNullable(clazz.cast(imageId()));
        case "targetStorageClass":
            return Optional.ofNullable(clazz.cast(targetStorageClassAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("imageId", IMAGE_ID_FIELD);
        map.put("targetStorageClass", TARGET_STORAGE_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateImageStorageClassRequest, T> g) {
        return obj -> g.apply((UpdateImageStorageClassRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateImageStorageClassRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry that contains the image to transition. If you
         * do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry that contains the image to transition.
         *        If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository that contains the image to transition.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the image to transition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * @param imageId
         *        The new value for the ImageId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageId(ImageIdentifier imageId);

        /**
         * Sets the value of the ImageId property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ImageIdentifier.Builder} avoiding the
         * need to create one manually via {@link ImageIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #imageId(ImageIdentifier)}.
         * 
         * @param imageId
         *        a consumer that will call methods on {@link ImageIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #imageId(ImageIdentifier)
         */
        default Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return imageId(ImageIdentifier.builder().applyMutation(imageId).build());
        }

        /**
         * <p>
         * The target storage class for the image.
         * </p>
         * 
         * @param targetStorageClass
         *        The target storage class for the image.
         * @see TargetStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStorageClass
         */
        Builder targetStorageClass(String targetStorageClass);

        /**
         * <p>
         * The target storage class for the image.
         * </p>
         * 
         * @param targetStorageClass
         *        The target storage class for the image.
         * @see TargetStorageClass
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TargetStorageClass
         */
        Builder targetStorageClass(TargetStorageClass targetStorageClass);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private ImageIdentifier imageId;

        private String targetStorageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateImageStorageClassRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            imageId(model.imageId);
            targetStorageClass(model.targetStorageClass);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return imageId != null ? imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final String getTargetStorageClass() {
            return targetStorageClass;
        }

        public final void setTargetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
        }

        @Override
        public final Builder targetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
            return this;
        }

        @Override
        public final Builder targetStorageClass(TargetStorageClass targetStorageClass) {
            this.targetStorageClass(targetStorageClass == null ? null : targetStorageClass.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateImageStorageClassRequest build() {
            return new UpdateImageStorageClassRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
