/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A repository filter used to determine which repositories have their images automatically signed on push. Each filter
 * consists of a filter type and filter value.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SigningRepositoryFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<SigningRepositoryFilter.Builder, SigningRepositoryFilter> {
    private static final SdkField<String> FILTER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("filter")
            .getter(getter(SigningRepositoryFilter::filter)).setter(setter(Builder::filter))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("filterType").getter(getter(SigningRepositoryFilter::filterTypeAsString))
            .setter(setter(Builder::filterType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_FIELD,
            FILTER_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String filter;

    private final String filterType;

    private SigningRepositoryFilter(BuilderImpl builder) {
        this.filter = builder.filter;
        this.filterType = builder.filterType;
    }

    /**
     * <p>
     * The filter value used to match repository names. When using <code>WILDCARD_MATCH</code>, the <code>*</code>
     * character matches any sequence of characters.
     * </p>
     * <p>
     * Examples:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>myapp/*</code> - Matches all repositories starting with <code>myapp/</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>*&#47;production</code> - Matches all repositories ending with <code>/production</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>*prod*</code> - Matches all repositories containing <code>prod</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The filter value used to match repository names. When using <code>WILDCARD_MATCH</code>, the
     *         <code>*</code> character matches any sequence of characters.</p>
     *         <p>
     *         Examples:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>myapp/*</code> - Matches all repositories starting with <code>myapp/</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>*&#47;production</code> - Matches all repositories ending with <code>/production</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>*prod*</code> - Matches all repositories containing <code>prod</code>
     *         </p>
     *         </li>
     */
    public final String filter() {
        return filter;
    }

    /**
     * <p>
     * The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses wildcard
     * patterns to match repository names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link SigningRepositoryFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses
     *         wildcard patterns to match repository names.
     * @see SigningRepositoryFilterType
     */
    public final SigningRepositoryFilterType filterType() {
        return SigningRepositoryFilterType.fromValue(filterType);
    }

    /**
     * <p>
     * The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses wildcard
     * patterns to match repository names.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #filterType} will
     * return {@link SigningRepositoryFilterType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #filterTypeAsString}.
     * </p>
     * 
     * @return The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses
     *         wildcard patterns to match repository names.
     * @see SigningRepositoryFilterType
     */
    public final String filterTypeAsString() {
        return filterType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(filterTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SigningRepositoryFilter)) {
            return false;
        }
        SigningRepositoryFilter other = (SigningRepositoryFilter) obj;
        return Objects.equals(filter(), other.filter()) && Objects.equals(filterTypeAsString(), other.filterTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SigningRepositoryFilter").add("Filter", filter()).add("FilterType", filterTypeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "filterType":
            return Optional.ofNullable(clazz.cast(filterTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("filter", FILTER_FIELD);
        map.put("filterType", FILTER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SigningRepositoryFilter, T> g) {
        return obj -> g.apply((SigningRepositoryFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SigningRepositoryFilter> {
        /**
         * <p>
         * The filter value used to match repository names. When using <code>WILDCARD_MATCH</code>, the <code>*</code>
         * character matches any sequence of characters.
         * </p>
         * <p>
         * Examples:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>myapp/*</code> - Matches all repositories starting with <code>myapp/</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>*&#47;production</code> - Matches all repositories ending with <code>/production</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>*prod*</code> - Matches all repositories containing <code>prod</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param filter
         *        The filter value used to match repository names. When using <code>WILDCARD_MATCH</code>, the
         *        <code>*</code> character matches any sequence of characters.</p>
         *        <p>
         *        Examples:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>myapp/*</code> - Matches all repositories starting with <code>myapp/</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>*&#47;production</code> - Matches all repositories ending with <code>/production</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>*prod*</code> - Matches all repositories containing <code>prod</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(String filter);

        /**
         * <p>
         * The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses wildcard
         * patterns to match repository names.
         * </p>
         * 
         * @param filterType
         *        The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses
         *        wildcard patterns to match repository names.
         * @see SigningRepositoryFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningRepositoryFilterType
         */
        Builder filterType(String filterType);

        /**
         * <p>
         * The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses wildcard
         * patterns to match repository names.
         * </p>
         * 
         * @param filterType
         *        The type of filter to apply. Currently, only <code>WILDCARD_MATCH</code> is supported, which uses
         *        wildcard patterns to match repository names.
         * @see SigningRepositoryFilterType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningRepositoryFilterType
         */
        Builder filterType(SigningRepositoryFilterType filterType);
    }

    static final class BuilderImpl implements Builder {
        private String filter;

        private String filterType;

        private BuilderImpl() {
        }

        private BuilderImpl(SigningRepositoryFilter model) {
            filter(model.filter);
            filterType(model.filterType);
        }

        public final String getFilter() {
            return filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public final String getFilterType() {
            return filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(SigningRepositoryFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        @Override
        public SigningRepositoryFilter build() {
            return new SigningRepositoryFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
