/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListPullTimeUpdateExclusionsResponse extends EcrResponse implements
        ToCopyableBuilder<ListPullTimeUpdateExclusionsResponse.Builder, ListPullTimeUpdateExclusionsResponse> {
    private static final SdkField<List<String>> PULL_TIME_UPDATE_EXCLUSIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("pullTimeUpdateExclusions")
            .getter(getter(ListPullTimeUpdateExclusionsResponse::pullTimeUpdateExclusions))
            .setter(setter(Builder::pullTimeUpdateExclusions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullTimeUpdateExclusions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListPullTimeUpdateExclusionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            PULL_TIME_UPDATE_EXCLUSIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<String> pullTimeUpdateExclusions;

    private final String nextToken;

    private ListPullTimeUpdateExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.pullTimeUpdateExclusions = builder.pullTimeUpdateExclusions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the PullTimeUpdateExclusions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasPullTimeUpdateExclusions() {
        return pullTimeUpdateExclusions != null && !(pullTimeUpdateExclusions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The list of IAM principal ARNs that are excluded from having their image pull times recorded.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasPullTimeUpdateExclusions} method.
     * </p>
     * 
     * @return The list of IAM principal ARNs that are excluded from having their image pull times recorded.
     */
    public final List<String> pullTimeUpdateExclusions() {
        return pullTimeUpdateExclusions;
    }

    /**
     * <p>
     * The <code>nextToken</code> value to include in a future <code>ListPullTimeUpdateExclusions</code> request. When
     * the results of a <code>ListPullTimeUpdateExclusions</code> request exceed <code>maxResults</code>, this value can
     * be used to retrieve the next page of results. This value is <code>null</code> when there are no more results to
     * return.
     * </p>
     * 
     * @return The <code>nextToken</code> value to include in a future <code>ListPullTimeUpdateExclusions</code>
     *         request. When the results of a <code>ListPullTimeUpdateExclusions</code> request exceed
     *         <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
     *         <code>null</code> when there are no more results to return.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasPullTimeUpdateExclusions() ? pullTimeUpdateExclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPullTimeUpdateExclusionsResponse)) {
            return false;
        }
        ListPullTimeUpdateExclusionsResponse other = (ListPullTimeUpdateExclusionsResponse) obj;
        return hasPullTimeUpdateExclusions() == other.hasPullTimeUpdateExclusions()
                && Objects.equals(pullTimeUpdateExclusions(), other.pullTimeUpdateExclusions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListPullTimeUpdateExclusionsResponse")
                .add("PullTimeUpdateExclusions", hasPullTimeUpdateExclusions() ? pullTimeUpdateExclusions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "pullTimeUpdateExclusions":
            return Optional.ofNullable(clazz.cast(pullTimeUpdateExclusions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("pullTimeUpdateExclusions", PULL_TIME_UPDATE_EXCLUSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPullTimeUpdateExclusionsResponse, T> g) {
        return obj -> g.apply((ListPullTimeUpdateExclusionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListPullTimeUpdateExclusionsResponse> {
        /**
         * <p>
         * The list of IAM principal ARNs that are excluded from having their image pull times recorded.
         * </p>
         * 
         * @param pullTimeUpdateExclusions
         *        The list of IAM principal ARNs that are excluded from having their image pull times recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullTimeUpdateExclusions(Collection<String> pullTimeUpdateExclusions);

        /**
         * <p>
         * The list of IAM principal ARNs that are excluded from having their image pull times recorded.
         * </p>
         * 
         * @param pullTimeUpdateExclusions
         *        The list of IAM principal ARNs that are excluded from having their image pull times recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pullTimeUpdateExclusions(String... pullTimeUpdateExclusions);

        /**
         * <p>
         * The <code>nextToken</code> value to include in a future <code>ListPullTimeUpdateExclusions</code> request.
         * When the results of a <code>ListPullTimeUpdateExclusions</code> request exceed <code>maxResults</code>, this
         * value can be used to retrieve the next page of results. This value is <code>null</code> when there are no
         * more results to return.
         * </p>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value to include in a future <code>ListPullTimeUpdateExclusions</code>
         *        request. When the results of a <code>ListPullTimeUpdateExclusions</code> request exceed
         *        <code>maxResults</code>, this value can be used to retrieve the next page of results. This value is
         *        <code>null</code> when there are no more results to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends EcrResponse.BuilderImpl implements Builder {
        private List<String> pullTimeUpdateExclusions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPullTimeUpdateExclusionsResponse model) {
            super(model);
            pullTimeUpdateExclusions(model.pullTimeUpdateExclusions);
            nextToken(model.nextToken);
        }

        public final Collection<String> getPullTimeUpdateExclusions() {
            if (pullTimeUpdateExclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return pullTimeUpdateExclusions;
        }

        public final void setPullTimeUpdateExclusions(Collection<String> pullTimeUpdateExclusions) {
            this.pullTimeUpdateExclusions = PullTimeUpdateExclusionListCopier.copy(pullTimeUpdateExclusions);
        }

        @Override
        public final Builder pullTimeUpdateExclusions(Collection<String> pullTimeUpdateExclusions) {
            this.pullTimeUpdateExclusions = PullTimeUpdateExclusionListCopier.copy(pullTimeUpdateExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullTimeUpdateExclusions(String... pullTimeUpdateExclusions) {
            pullTimeUpdateExclusions(Arrays.asList(pullTimeUpdateExclusions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPullTimeUpdateExclusionsResponse build() {
            return new ListPullTimeUpdateExclusionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
