/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListImageReferrersRequest extends EcrRequest implements
        ToCopyableBuilder<ListImageReferrersRequest.Builder, ListImageReferrersRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(ListImageReferrersRequest::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("repositoryName").getter(getter(ListImageReferrersRequest::repositoryName))
            .setter(setter(Builder::repositoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()).build();

    private static final SdkField<SubjectIdentifier> SUBJECT_ID_FIELD = SdkField
            .<SubjectIdentifier> builder(MarshallingType.SDK_POJO).memberName("subjectId")
            .getter(getter(ListImageReferrersRequest::subjectId)).setter(setter(Builder::subjectId))
            .constructor(SubjectIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subjectId").build()).build();

    private static final SdkField<ListImageReferrersFilter> FILTER_FIELD = SdkField
            .<ListImageReferrersFilter> builder(MarshallingType.SDK_POJO).memberName("filter")
            .getter(getter(ListImageReferrersRequest::filter)).setter(setter(Builder::filter))
            .constructor(ListImageReferrersFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListImageReferrersRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListImageReferrersRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD,
            REPOSITORY_NAME_FIELD, SUBJECT_ID_FIELD, FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String registryId;

    private final String repositoryName;

    private final SubjectIdentifier subjectId;

    private final ListImageReferrersFilter filter;

    private final String nextToken;

    private final Integer maxResults;

    private ListImageReferrersRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.subjectId = builder.subjectId;
        this.filter = builder.filter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry that contains the repository in which to list
     * image referrers. If you do not specify a registry, the default registry is assumed.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry that contains the repository in which to
     *         list image referrers. If you do not specify a registry, the default registry is assumed.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The name of the repository that contains the subject image.
     * </p>
     * 
     * @return The name of the repository that contains the subject image.
     */
    public final String repositoryName() {
        return repositoryName;
    }

    /**
     * <p>
     * An object containing the image digest of the subject image for which to retrieve associated artifacts.
     * </p>
     * 
     * @return An object containing the image digest of the subject image for which to retrieve associated artifacts.
     */
    public final SubjectIdentifier subjectId() {
        return subjectId;
    }

    /**
     * <p>
     * The filter key and value with which to filter your <code>ListImageReferrers</code> results. If no filter is
     * specified, only artifacts with <code>ACTIVE</code> status are returned.
     * </p>
     * 
     * @return The filter key and value with which to filter your <code>ListImageReferrers</code> results. If no filter
     *         is specified, only artifacts with <code>ACTIVE</code> status are returned.
     */
    public final ListImageReferrersFilter filter() {
        return filter;
    }

    /**
     * <p>
     * The <code>nextToken</code> value returned from a previous paginated <code>ListImageReferrers</code> request where
     * <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination continues from
     * the end of the previous results that returned the <code>nextToken</code> value. This value is <code>null</code>
     * when there are no more results to return.
     * </p>
     * <note>
     * <p>
     * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list and
     * not for other programmatic purposes.
     * </p>
     * </note>
     * 
     * @return The <code>nextToken</code> value returned from a previous paginated <code>ListImageReferrers</code>
     *         request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
     *         Pagination continues from the end of the previous results that returned the <code>nextToken</code> value.
     *         This value is <code>null</code> when there are no more results to return.</p> <note>
     *         <p>
     *         This token should be treated as an opaque identifier that is only used to retrieve the next items in a
     *         list and not for other programmatic purposes.
     *         </p>
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of image referrer results returned by <code>ListImageReferrers</code> in paginated output.
     * When this parameter is used, <code>ListImageReferrers</code> only returns <code>maxResults</code> results in a
     * single page along with a <code>nextToken</code> response element. The remaining results of the initial request
     * can be seen by sending another <code>ListImageReferrers</code> request with the returned <code>nextToken</code>
     * value. This value can be between 1 and 50. If this parameter is not used, then <code>ListImageReferrers</code>
     * returns up to 50 results and a <code>nextToken</code> value, if applicable.
     * </p>
     * 
     * @return The maximum number of image referrer results returned by <code>ListImageReferrers</code> in paginated
     *         output. When this parameter is used, <code>ListImageReferrers</code> only returns <code>maxResults</code>
     *         results in a single page along with a <code>nextToken</code> response element. The remaining results of
     *         the initial request can be seen by sending another <code>ListImageReferrers</code> request with the
     *         returned <code>nextToken</code> value. This value can be between 1 and 50. If this parameter is not used,
     *         then <code>ListImageReferrers</code> returns up to 50 results and a <code>nextToken</code> value, if
     *         applicable.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(subjectId());
        hashCode = 31 * hashCode + Objects.hashCode(filter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageReferrersRequest)) {
            return false;
        }
        ListImageReferrersRequest other = (ListImageReferrersRequest) obj;
        return Objects.equals(registryId(), other.registryId()) && Objects.equals(repositoryName(), other.repositoryName())
                && Objects.equals(subjectId(), other.subjectId()) && Objects.equals(filter(), other.filter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListImageReferrersRequest").add("RegistryId", registryId())
                .add("RepositoryName", repositoryName()).add("SubjectId", subjectId()).add("Filter", filter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "repositoryName":
            return Optional.ofNullable(clazz.cast(repositoryName()));
        case "subjectId":
            return Optional.ofNullable(clazz.cast(subjectId()));
        case "filter":
            return Optional.ofNullable(clazz.cast(filter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("subjectId", SUBJECT_ID_FIELD);
        map.put("filter", FILTER_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImageReferrersRequest, T> g) {
        return obj -> g.apply((ListImageReferrersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends EcrRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListImageReferrersRequest> {
        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry that contains the repository in which to list
         * image referrers. If you do not specify a registry, the default registry is assumed.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry that contains the repository in which
         *        to list image referrers. If you do not specify a registry, the default registry is assumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The name of the repository that contains the subject image.
         * </p>
         * 
         * @param repositoryName
         *        The name of the repository that contains the subject image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder repositoryName(String repositoryName);

        /**
         * <p>
         * An object containing the image digest of the subject image for which to retrieve associated artifacts.
         * </p>
         * 
         * @param subjectId
         *        An object containing the image digest of the subject image for which to retrieve associated artifacts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder subjectId(SubjectIdentifier subjectId);

        /**
         * <p>
         * An object containing the image digest of the subject image for which to retrieve associated artifacts.
         * </p>
         * This is a convenience method that creates an instance of the {@link SubjectIdentifier.Builder} avoiding the
         * need to create one manually via {@link SubjectIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SubjectIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #subjectId(SubjectIdentifier)}.
         * 
         * @param subjectId
         *        a consumer that will call methods on {@link SubjectIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #subjectId(SubjectIdentifier)
         */
        default Builder subjectId(Consumer<SubjectIdentifier.Builder> subjectId) {
            return subjectId(SubjectIdentifier.builder().applyMutation(subjectId).build());
        }

        /**
         * <p>
         * The filter key and value with which to filter your <code>ListImageReferrers</code> results. If no filter is
         * specified, only artifacts with <code>ACTIVE</code> status are returned.
         * </p>
         * 
         * @param filter
         *        The filter key and value with which to filter your <code>ListImageReferrers</code> results. If no
         *        filter is specified, only artifacts with <code>ACTIVE</code> status are returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filter(ListImageReferrersFilter filter);

        /**
         * <p>
         * The filter key and value with which to filter your <code>ListImageReferrers</code> results. If no filter is
         * specified, only artifacts with <code>ACTIVE</code> status are returned.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListImageReferrersFilter.Builder}
         * avoiding the need to create one manually via {@link ListImageReferrersFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListImageReferrersFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #filter(ListImageReferrersFilter)}.
         * 
         * @param filter
         *        a consumer that will call methods on {@link ListImageReferrersFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filter(ListImageReferrersFilter)
         */
        default Builder filter(Consumer<ListImageReferrersFilter.Builder> filter) {
            return filter(ListImageReferrersFilter.builder().applyMutation(filter).build());
        }

        /**
         * <p>
         * The <code>nextToken</code> value returned from a previous paginated <code>ListImageReferrers</code> request
         * where <code>maxResults</code> was used and the results exceeded the value of that parameter. Pagination
         * continues from the end of the previous results that returned the <code>nextToken</code> value. This value is
         * <code>null</code> when there are no more results to return.
         * </p>
         * <note>
         * <p>
         * This token should be treated as an opaque identifier that is only used to retrieve the next items in a list
         * and not for other programmatic purposes.
         * </p>
         * </note>
         * 
         * @param nextToken
         *        The <code>nextToken</code> value returned from a previous paginated <code>ListImageReferrers</code>
         *        request where <code>maxResults</code> was used and the results exceeded the value of that parameter.
         *        Pagination continues from the end of the previous results that returned the <code>nextToken</code>
         *        value. This value is <code>null</code> when there are no more results to return.</p> <note>
         *        <p>
         *        This token should be treated as an opaque identifier that is only used to retrieve the next items in a
         *        list and not for other programmatic purposes.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of image referrer results returned by <code>ListImageReferrers</code> in paginated output.
         * When this parameter is used, <code>ListImageReferrers</code> only returns <code>maxResults</code> results in
         * a single page along with a <code>nextToken</code> response element. The remaining results of the initial
         * request can be seen by sending another <code>ListImageReferrers</code> request with the returned
         * <code>nextToken</code> value. This value can be between 1 and 50. If this parameter is not used, then
         * <code>ListImageReferrers</code> returns up to 50 results and a <code>nextToken</code> value, if applicable.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of image referrer results returned by <code>ListImageReferrers</code> in paginated
         *        output. When this parameter is used, <code>ListImageReferrers</code> only returns
         *        <code>maxResults</code> results in a single page along with a <code>nextToken</code> response element.
         *        The remaining results of the initial request can be seen by sending another
         *        <code>ListImageReferrers</code> request with the returned <code>nextToken</code> value. This value can
         *        be between 1 and 50. If this parameter is not used, then <code>ListImageReferrers</code> returns up to
         *        50 results and a <code>nextToken</code> value, if applicable.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends EcrRequest.BuilderImpl implements Builder {
        private String registryId;

        private String repositoryName;

        private SubjectIdentifier subjectId;

        private ListImageReferrersFilter filter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageReferrersRequest model) {
            super(model);
            registryId(model.registryId);
            repositoryName(model.repositoryName);
            subjectId(model.subjectId);
            filter(model.filter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final SubjectIdentifier.Builder getSubjectId() {
            return subjectId != null ? subjectId.toBuilder() : null;
        }

        public final void setSubjectId(SubjectIdentifier.BuilderImpl subjectId) {
            this.subjectId = subjectId != null ? subjectId.build() : null;
        }

        @Override
        public final Builder subjectId(SubjectIdentifier subjectId) {
            this.subjectId = subjectId;
            return this;
        }

        public final ListImageReferrersFilter.Builder getFilter() {
            return filter != null ? filter.toBuilder() : null;
        }

        public final void setFilter(ListImageReferrersFilter.BuilderImpl filter) {
            this.filter = filter != null ? filter.build() : null;
        }

        @Override
        public final Builder filter(ListImageReferrersFilter filter) {
            this.filter = filter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListImageReferrersRequest build() {
            return new ListImageReferrersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
