/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The signing status for an image. Each status corresponds to a signing profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ImageSigningStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ImageSigningStatus.Builder, ImageSigningStatus> {
    private static final SdkField<String> SIGNING_PROFILE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("signingProfileArn").getter(getter(ImageSigningStatus::signingProfileArn))
            .setter(setter(Builder::signingProfileArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingProfileArn").build()).build();

    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureCode").getter(getter(ImageSigningStatus::failureCode)).setter(setter(Builder::failureCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()).build();

    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("failureReason").getter(getter(ImageSigningStatus::failureReason)).setter(setter(Builder::failureReason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ImageSigningStatus::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_PROFILE_ARN_FIELD,
            FAILURE_CODE_FIELD, FAILURE_REASON_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String signingProfileArn;

    private final String failureCode;

    private final String failureReason;

    private final String status;

    private ImageSigningStatus(BuilderImpl builder) {
        this.signingProfileArn = builder.signingProfileArn;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.status = builder.status;
    }

    /**
     * <p>
     * The ARN of the Amazon Web Services Signer signing profile used to sign the image.
     * </p>
     * 
     * @return The ARN of the Amazon Web Services Signer signing profile used to sign the image.
     */
    public final String signingProfileArn() {
        return signingProfileArn;
    }

    /**
     * <p>
     * The failure code, which is only present if <code>status</code> is <code>FAILED</code>.
     * </p>
     * 
     * @return The failure code, which is only present if <code>status</code> is <code>FAILED</code>.
     */
    public final String failureCode() {
        return failureCode;
    }

    /**
     * <p>
     * A description of why signing the image failed. This field is only present if <code>status</code> is
     * <code>FAILED</code>.
     * </p>
     * 
     * @return A description of why signing the image failed. This field is only present if <code>status</code> is
     *         <code>FAILED</code>.
     */
    public final String failureReason() {
        return failureReason;
    }

    /**
     * <p>
     * The image's signing status. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Signing is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - The signature was successfully generated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for details.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The image's signing status. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Signing is currently in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - The signature was successfully generated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for
     *         details.
     *         </p>
     *         </li>
     * @see SigningStatus
     */
    public final SigningStatus status() {
        return SigningStatus.fromValue(status);
    }

    /**
     * <p>
     * The image's signing status. Possible values are:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - Signing is currently in progress.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>COMPLETE</code> - The signature was successfully generated.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for details.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link SigningStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The image's signing status. Possible values are:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - Signing is currently in progress.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>COMPLETE</code> - The signature was successfully generated.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for
     *         details.
     *         </p>
     *         </li>
     * @see SigningStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(signingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSigningStatus)) {
            return false;
        }
        ImageSigningStatus other = (ImageSigningStatus) obj;
        return Objects.equals(signingProfileArn(), other.signingProfileArn())
                && Objects.equals(failureCode(), other.failureCode()) && Objects.equals(failureReason(), other.failureReason())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ImageSigningStatus").add("SigningProfileArn", signingProfileArn())
                .add("FailureCode", failureCode()).add("FailureReason", failureReason()).add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "signingProfileArn":
            return Optional.ofNullable(clazz.cast(signingProfileArn()));
        case "failureCode":
            return Optional.ofNullable(clazz.cast(failureCode()));
        case "failureReason":
            return Optional.ofNullable(clazz.cast(failureReason()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("signingProfileArn", SIGNING_PROFILE_ARN_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSigningStatus, T> g) {
        return obj -> g.apply((ImageSigningStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ImageSigningStatus> {
        /**
         * <p>
         * The ARN of the Amazon Web Services Signer signing profile used to sign the image.
         * </p>
         * 
         * @param signingProfileArn
         *        The ARN of the Amazon Web Services Signer signing profile used to sign the image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder signingProfileArn(String signingProfileArn);

        /**
         * <p>
         * The failure code, which is only present if <code>status</code> is <code>FAILED</code>.
         * </p>
         * 
         * @param failureCode
         *        The failure code, which is only present if <code>status</code> is <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureCode(String failureCode);

        /**
         * <p>
         * A description of why signing the image failed. This field is only present if <code>status</code> is
         * <code>FAILED</code>.
         * </p>
         * 
         * @param failureReason
         *        A description of why signing the image failed. This field is only present if <code>status</code> is
         *        <code>FAILED</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder failureReason(String failureReason);

        /**
         * <p>
         * The image's signing status. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Signing is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - The signature was successfully generated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for
         * details.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The image's signing status. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Signing is currently in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - The signature was successfully generated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for
         *        details.
         *        </p>
         *        </li>
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The image's signing status. Possible values are:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - Signing is currently in progress.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>COMPLETE</code> - The signature was successfully generated.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for
         * details.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The image's signing status. Possible values are:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - Signing is currently in progress.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>COMPLETE</code> - The signature was successfully generated.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code> - Signing failed. See <code>failureCode</code> and <code>failureReason</code> for
         *        details.
         *        </p>
         *        </li>
         * @see SigningStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SigningStatus
         */
        Builder status(SigningStatus status);
    }

    static final class BuilderImpl implements Builder {
        private String signingProfileArn;

        private String failureCode;

        private String failureReason;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSigningStatus model) {
            signingProfileArn(model.signingProfileArn);
            failureCode(model.failureCode);
            failureReason(model.failureReason);
            status(model.status);
        }

        public final String getSigningProfileArn() {
            return signingProfileArn;
        }

        public final void setSigningProfileArn(String signingProfileArn) {
            this.signingProfileArn = signingProfileArn;
        }

        @Override
        public final Builder signingProfileArn(String signingProfileArn) {
            this.signingProfileArn = signingProfileArn;
            return this;
        }

        public final String getFailureCode() {
            return failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureReason() {
            return failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public ImageSigningStatus build() {
            return new ImageSigningStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
