/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.ImageTagMutabilityExclusionFilterType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageTagMutabilityExclusionFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageTagMutabilityExclusionFilter> {
    private static final SdkField<String> FILTER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filterType").getter(ImageTagMutabilityExclusionFilter.getter(ImageTagMutabilityExclusionFilter::filterTypeAsString)).setter(ImageTagMutabilityExclusionFilter.setter(Builder::filterType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterType").build()}).build();
    private static final SdkField<String> FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("filter").getter(ImageTagMutabilityExclusionFilter.getter(ImageTagMutabilityExclusionFilter::filter)).setter(ImageTagMutabilityExclusionFilter.setter(Builder::filter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filter").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FILTER_TYPE_FIELD, FILTER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageTagMutabilityExclusionFilter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String filterType;
    private final String filter;

    private ImageTagMutabilityExclusionFilter(BuilderImpl builder) {
        this.filterType = builder.filterType;
        this.filter = builder.filter;
    }

    public final ImageTagMutabilityExclusionFilterType filterType() {
        return ImageTagMutabilityExclusionFilterType.fromValue(this.filterType);
    }

    public final String filterTypeAsString() {
        return this.filterType;
    }

    public final String filter() {
        return this.filter;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.filterTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.filter());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageTagMutabilityExclusionFilter)) {
            return false;
        }
        ImageTagMutabilityExclusionFilter other = (ImageTagMutabilityExclusionFilter)obj;
        return Objects.equals(this.filterTypeAsString(), other.filterTypeAsString()) && Objects.equals(this.filter(), other.filter());
    }

    public final String toString() {
        return ToString.builder((String)"ImageTagMutabilityExclusionFilter").add("FilterType", (Object)this.filterTypeAsString()).add("Filter", (Object)this.filter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "filterType": {
                return Optional.ofNullable(clazz.cast(this.filterTypeAsString()));
            }
            case "filter": {
                return Optional.ofNullable(clazz.cast(this.filter()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("filterType", FILTER_TYPE_FIELD);
        map.put("filter", FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageTagMutabilityExclusionFilter, T> g) {
        return obj -> g.apply((ImageTagMutabilityExclusionFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String filterType;
        private String filter;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageTagMutabilityExclusionFilter model) {
            this.filterType(model.filterType);
            this.filter(model.filter);
        }

        public final String getFilterType() {
            return this.filterType;
        }

        public final void setFilterType(String filterType) {
            this.filterType = filterType;
        }

        @Override
        public final Builder filterType(String filterType) {
            this.filterType = filterType;
            return this;
        }

        @Override
        public final Builder filterType(ImageTagMutabilityExclusionFilterType filterType) {
            this.filterType(filterType == null ? null : filterType.toString());
            return this;
        }

        public final String getFilter() {
            return this.filter;
        }

        public final void setFilter(String filter) {
            this.filter = filter;
        }

        @Override
        public final Builder filter(String filter) {
            this.filter = filter;
            return this;
        }

        public ImageTagMutabilityExclusionFilter build() {
            return new ImageTagMutabilityExclusionFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageTagMutabilityExclusionFilter> {
        public Builder filterType(String var1);

        public Builder filterType(ImageTagMutabilityExclusionFilterType var1);

        public Builder filter(String var1);
    }
}

