/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.SigningStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageSigningStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageSigningStatus> {
    private static final SdkField<String> SIGNING_PROFILE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("signingProfileArn").getter(ImageSigningStatus.getter(ImageSigningStatus::signingProfileArn)).setter(ImageSigningStatus.setter(Builder::signingProfileArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("signingProfileArn").build()}).build();
    private static final SdkField<String> FAILURE_CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureCode").getter(ImageSigningStatus.getter(ImageSigningStatus::failureCode)).setter(ImageSigningStatus.setter(Builder::failureCode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCode").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(ImageSigningStatus.getter(ImageSigningStatus::failureReason)).setter(ImageSigningStatus.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ImageSigningStatus.getter(ImageSigningStatus::statusAsString)).setter(ImageSigningStatus.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SIGNING_PROFILE_ARN_FIELD, FAILURE_CODE_FIELD, FAILURE_REASON_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ImageSigningStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String signingProfileArn;
    private final String failureCode;
    private final String failureReason;
    private final String status;

    private ImageSigningStatus(BuilderImpl builder) {
        this.signingProfileArn = builder.signingProfileArn;
        this.failureCode = builder.failureCode;
        this.failureReason = builder.failureReason;
        this.status = builder.status;
    }

    public final String signingProfileArn() {
        return this.signingProfileArn;
    }

    public final String failureCode() {
        return this.failureCode;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final SigningStatus status() {
        return SigningStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.signingProfileArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCode());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageSigningStatus)) {
            return false;
        }
        ImageSigningStatus other = (ImageSigningStatus)obj;
        return Objects.equals(this.signingProfileArn(), other.signingProfileArn()) && Objects.equals(this.failureCode(), other.failureCode()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ImageSigningStatus").add("SigningProfileArn", (Object)this.signingProfileArn()).add("FailureCode", (Object)this.failureCode()).add("FailureReason", (Object)this.failureReason()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "signingProfileArn": {
                return Optional.ofNullable(clazz.cast(this.signingProfileArn()));
            }
            case "failureCode": {
                return Optional.ofNullable(clazz.cast(this.failureCode()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("signingProfileArn", SIGNING_PROFILE_ARN_FIELD);
        map.put("failureCode", FAILURE_CODE_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ImageSigningStatus, T> g) {
        return obj -> g.apply((ImageSigningStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String signingProfileArn;
        private String failureCode;
        private String failureReason;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageSigningStatus model) {
            this.signingProfileArn(model.signingProfileArn);
            this.failureCode(model.failureCode);
            this.failureReason(model.failureReason);
            this.status(model.status);
        }

        public final String getSigningProfileArn() {
            return this.signingProfileArn;
        }

        public final void setSigningProfileArn(String signingProfileArn) {
            this.signingProfileArn = signingProfileArn;
        }

        @Override
        public final Builder signingProfileArn(String signingProfileArn) {
            this.signingProfileArn = signingProfileArn;
            return this;
        }

        public final String getFailureCode() {
            return this.failureCode;
        }

        public final void setFailureCode(String failureCode) {
            this.failureCode = failureCode;
        }

        @Override
        public final Builder failureCode(String failureCode) {
            this.failureCode = failureCode;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SigningStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public ImageSigningStatus build() {
            return new ImageSigningStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageSigningStatus> {
        public Builder signingProfileArn(String var1);

        public Builder failureCode(String var1);

        public Builder failureReason(String var1);

        public Builder status(String var1);

        public Builder status(SigningStatus var1);
    }
}

