/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.PullTimeUpdateExclusionListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPullTimeUpdateExclusionsResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, ListPullTimeUpdateExclusionsResponse> {
    private static final SdkField<List<String>> PULL_TIME_UPDATE_EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("pullTimeUpdateExclusions").getter(ListPullTimeUpdateExclusionsResponse.getter(ListPullTimeUpdateExclusionsResponse::pullTimeUpdateExclusions)).setter(ListPullTimeUpdateExclusionsResponse.setter(Builder::pullTimeUpdateExclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pullTimeUpdateExclusions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPullTimeUpdateExclusionsResponse.getter(ListPullTimeUpdateExclusionsResponse::nextToken)).setter(ListPullTimeUpdateExclusionsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PULL_TIME_UPDATE_EXCLUSIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPullTimeUpdateExclusionsResponse.memberNameToFieldInitializer();
    private final List<String> pullTimeUpdateExclusions;
    private final String nextToken;

    private ListPullTimeUpdateExclusionsResponse(BuilderImpl builder) {
        super(builder);
        this.pullTimeUpdateExclusions = builder.pullTimeUpdateExclusions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasPullTimeUpdateExclusions() {
        return this.pullTimeUpdateExclusions != null && !(this.pullTimeUpdateExclusions instanceof SdkAutoConstructList);
    }

    public final List<String> pullTimeUpdateExclusions() {
        return this.pullTimeUpdateExclusions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPullTimeUpdateExclusions() ? this.pullTimeUpdateExclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPullTimeUpdateExclusionsResponse)) {
            return false;
        }
        ListPullTimeUpdateExclusionsResponse other = (ListPullTimeUpdateExclusionsResponse)((Object)obj);
        return this.hasPullTimeUpdateExclusions() == other.hasPullTimeUpdateExclusions() && Objects.equals(this.pullTimeUpdateExclusions(), other.pullTimeUpdateExclusions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListPullTimeUpdateExclusionsResponse").add("PullTimeUpdateExclusions", this.hasPullTimeUpdateExclusions() ? this.pullTimeUpdateExclusions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "pullTimeUpdateExclusions": {
                return Optional.ofNullable(clazz.cast(this.pullTimeUpdateExclusions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pullTimeUpdateExclusions", PULL_TIME_UPDATE_EXCLUSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPullTimeUpdateExclusionsResponse, T> g) {
        return obj -> g.apply((ListPullTimeUpdateExclusionsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<String> pullTimeUpdateExclusions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPullTimeUpdateExclusionsResponse model) {
            super(model);
            this.pullTimeUpdateExclusions(model.pullTimeUpdateExclusions);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getPullTimeUpdateExclusions() {
            if (this.pullTimeUpdateExclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.pullTimeUpdateExclusions;
        }

        public final void setPullTimeUpdateExclusions(Collection<String> pullTimeUpdateExclusions) {
            this.pullTimeUpdateExclusions = PullTimeUpdateExclusionListCopier.copy(pullTimeUpdateExclusions);
        }

        @Override
        public final Builder pullTimeUpdateExclusions(Collection<String> pullTimeUpdateExclusions) {
            this.pullTimeUpdateExclusions = PullTimeUpdateExclusionListCopier.copy(pullTimeUpdateExclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder pullTimeUpdateExclusions(String ... pullTimeUpdateExclusions) {
            this.pullTimeUpdateExclusions(Arrays.asList(pullTimeUpdateExclusions));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListPullTimeUpdateExclusionsResponse build() {
            return new ListPullTimeUpdateExclusionsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPullTimeUpdateExclusionsResponse> {
        public Builder pullTimeUpdateExclusions(Collection<String> var1);

        public Builder pullTimeUpdateExclusions(String ... var1);

        public Builder nextToken(String var1);
    }
}

