/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.ImageReferrer;
import software.amazon.awssdk.services.ecr.model.ImageReferrerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListImageReferrersResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, ListImageReferrersResponse> {
    private static final SdkField<List<ImageReferrer>> REFERRERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("referrers").getter(ListImageReferrersResponse.getter(ListImageReferrersResponse::referrers)).setter(ListImageReferrersResponse.setter(Builder::referrers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("referrers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ImageReferrer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListImageReferrersResponse.getter(ListImageReferrersResponse::nextToken)).setter(ListImageReferrersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REFERRERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListImageReferrersResponse.memberNameToFieldInitializer();
    private final List<ImageReferrer> referrers;
    private final String nextToken;

    private ListImageReferrersResponse(BuilderImpl builder) {
        super(builder);
        this.referrers = builder.referrers;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasReferrers() {
        return this.referrers != null && !(this.referrers instanceof SdkAutoConstructList);
    }

    public final List<ImageReferrer> referrers() {
        return this.referrers;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReferrers() ? this.referrers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListImageReferrersResponse)) {
            return false;
        }
        ListImageReferrersResponse other = (ListImageReferrersResponse)((Object)obj);
        return this.hasReferrers() == other.hasReferrers() && Objects.equals(this.referrers(), other.referrers()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListImageReferrersResponse").add("Referrers", this.hasReferrers() ? this.referrers() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "referrers": {
                return Optional.ofNullable(clazz.cast(this.referrers()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("referrers", REFERRERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListImageReferrersResponse, T> g) {
        return obj -> g.apply((ListImageReferrersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<ImageReferrer> referrers = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListImageReferrersResponse model) {
            super(model);
            this.referrers(model.referrers);
            this.nextToken(model.nextToken);
        }

        public final List<ImageReferrer.Builder> getReferrers() {
            List<ImageReferrer.Builder> result = ImageReferrerListCopier.copyToBuilder(this.referrers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReferrers(Collection<ImageReferrer.BuilderImpl> referrers) {
            this.referrers = ImageReferrerListCopier.copyFromBuilder(referrers);
        }

        @Override
        public final Builder referrers(Collection<ImageReferrer> referrers) {
            this.referrers = ImageReferrerListCopier.copy(referrers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referrers(ImageReferrer ... referrers) {
            this.referrers(Arrays.asList(referrers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder referrers(Consumer<ImageReferrer.Builder> ... referrers) {
            this.referrers(Stream.of(referrers).map(c -> (ImageReferrer)((ImageReferrer.Builder)ImageReferrer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListImageReferrersResponse build() {
            return new ListImageReferrersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListImageReferrersResponse> {
        public Builder referrers(Collection<ImageReferrer> var1);

        public Builder referrers(ImageReferrer ... var1);

        public Builder referrers(Consumer<ImageReferrer.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

