/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageStatusFilter {
    ACTIVE("ACTIVE"),
    ARCHIVED("ARCHIVED"),
    ACTIVATING("ACTIVATING"),
    ANY("ANY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageStatusFilter> VALUE_MAP;
    private final String value;

    private ImageStatusFilter(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageStatusFilter fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageStatusFilter> knownValues() {
        EnumSet<ImageStatusFilter> knownValues = EnumSet.allOf(ImageStatusFilter.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageStatusFilter.class, ImageStatusFilter::toString);
    }
}

