/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.ImageActionType;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyTargetStorageClass;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LifecyclePolicyRuleAction
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LifecyclePolicyRuleAction> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(LifecyclePolicyRuleAction.getter(LifecyclePolicyRuleAction::typeAsString)).setter(LifecyclePolicyRuleAction.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<String> TARGET_STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetStorageClass").getter(LifecyclePolicyRuleAction.getter(LifecyclePolicyRuleAction::targetStorageClassAsString)).setter(LifecyclePolicyRuleAction.setter(Builder::targetStorageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetStorageClass").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, TARGET_STORAGE_CLASS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LifecyclePolicyRuleAction.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final String targetStorageClass;

    private LifecyclePolicyRuleAction(BuilderImpl builder) {
        this.type = builder.type;
        this.targetStorageClass = builder.targetStorageClass;
    }

    public final ImageActionType type() {
        return ImageActionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final LifecyclePolicyTargetStorageClass targetStorageClass() {
        return LifecyclePolicyTargetStorageClass.fromValue(this.targetStorageClass);
    }

    public final String targetStorageClassAsString() {
        return this.targetStorageClass;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetStorageClassAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LifecyclePolicyRuleAction)) {
            return false;
        }
        LifecyclePolicyRuleAction other = (LifecyclePolicyRuleAction)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.targetStorageClassAsString(), other.targetStorageClassAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LifecyclePolicyRuleAction").add("Type", (Object)this.typeAsString()).add("TargetStorageClass", (Object)this.targetStorageClassAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "targetStorageClass": {
                return Optional.ofNullable(clazz.cast(this.targetStorageClassAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("type", TYPE_FIELD);
        map.put("targetStorageClass", TARGET_STORAGE_CLASS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LifecyclePolicyRuleAction, T> g) {
        return obj -> g.apply((LifecyclePolicyRuleAction)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private String targetStorageClass;

        private BuilderImpl() {
        }

        private BuilderImpl(LifecyclePolicyRuleAction model) {
            this.type(model.type);
            this.targetStorageClass(model.targetStorageClass);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ImageActionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final String getTargetStorageClass() {
            return this.targetStorageClass;
        }

        public final void setTargetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
        }

        @Override
        public final Builder targetStorageClass(String targetStorageClass) {
            this.targetStorageClass = targetStorageClass;
            return this;
        }

        @Override
        public final Builder targetStorageClass(LifecyclePolicyTargetStorageClass targetStorageClass) {
            this.targetStorageClass(targetStorageClass == null ? null : targetStorageClass.toString());
            return this;
        }

        public LifecyclePolicyRuleAction build() {
            return new LifecyclePolicyRuleAction(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LifecyclePolicyRuleAction> {
        public Builder type(String var1);

        public Builder type(ImageActionType var1);

        public Builder targetStorageClass(String var1);

        public Builder targetStorageClass(LifecyclePolicyTargetStorageClass var1);
    }
}

