/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.services.ecr.model.AuthorizationDataListCopier;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAuthorizationTokenResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<List<AuthorizationData>> AUTHORIZATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("authorizationData").getter(GetAuthorizationTokenResponse.getter(GetAuthorizationTokenResponse::authorizationData)).setter(GetAuthorizationTokenResponse.setter(Builder::authorizationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_DATA_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAuthorizationTokenResponse.memberNameToFieldInitializer();
    private final List<AuthorizationData> authorizationData;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationData = builder.authorizationData;
    }

    public final boolean hasAuthorizationData() {
        return this.authorizationData != null && !(this.authorizationData instanceof SdkAutoConstructList);
    }

    public final List<AuthorizationData> authorizationData() {
        return this.authorizationData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAuthorizationData() ? this.authorizationData() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse)((Object)obj);
        return this.hasAuthorizationData() == other.hasAuthorizationData() && Objects.equals(this.authorizationData(), other.authorizationData());
    }

    public final String toString() {
        return ToString.builder((String)"GetAuthorizationTokenResponse").add("AuthorizationData", this.hasAuthorizationData() ? this.authorizationData() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationData": {
                return Optional.ofNullable(clazz.cast(this.authorizationData()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<AuthorizationData>>> map = new HashMap<String, SdkField<List<AuthorizationData>>>();
        map.put("authorizationData", AUTHORIZATION_DATA_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<AuthorizationData> authorizationData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            this.authorizationData(model.authorizationData);
        }

        public final List<AuthorizationData.Builder> getAuthorizationData() {
            List<AuthorizationData.Builder> result = AuthorizationDataListCopier.copyToBuilder(this.authorizationData);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAuthorizationData(Collection<AuthorizationData.BuilderImpl> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copyFromBuilder(authorizationData);
        }

        @Override
        public final Builder authorizationData(Collection<AuthorizationData> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copy(authorizationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(AuthorizationData ... authorizationData) {
            this.authorizationData(Arrays.asList(authorizationData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(Consumer<AuthorizationData.Builder> ... authorizationData) {
            this.authorizationData(Stream.of(authorizationData).map(c -> (AuthorizationData)((AuthorizationData.Builder)AuthorizationData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        public Builder authorizationData(Collection<AuthorizationData> var1);

        public Builder authorizationData(AuthorizationData ... var1);

        public Builder authorizationData(Consumer<AuthorizationData.Builder> ... var1);
    }
}

