/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a pull through cache rule.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PullThroughCacheRule implements SdkPojo, Serializable,
        ToCopyableBuilder<PullThroughCacheRule.Builder, PullThroughCacheRule> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ecrRepositoryPrefix").getter(getter(PullThroughCacheRule::ecrRepositoryPrefix))
            .setter(setter(Builder::ecrRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build())
            .build();

    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistryUrl").getter(getter(PullThroughCacheRule::upstreamRegistryUrl))
            .setter(setter(Builder::upstreamRegistryUrl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build())
            .build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt").getter(getter(PullThroughCacheRule::createdAt)).setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()).build();

    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("registryId").getter(getter(PullThroughCacheRule::registryId)).setter(setter(Builder::registryId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()).build();

    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("credentialArn").getter(getter(PullThroughCacheRule::credentialArn))
            .setter(setter(Builder::credentialArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()).build();

    private static final SdkField<String> CUSTOM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("customRoleArn").getter(getter(PullThroughCacheRule::customRoleArn))
            .setter(setter(Builder::customRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customRoleArn").build()).build();

    private static final SdkField<String> UPSTREAM_REPOSITORY_PREFIX_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRepositoryPrefix").getter(getter(PullThroughCacheRule::upstreamRepositoryPrefix))
            .setter(setter(Builder::upstreamRepositoryPrefix))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRepositoryPrefix").build())
            .build();

    private static final SdkField<String> UPSTREAM_REGISTRY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("upstreamRegistry").getter(getter(PullThroughCacheRule::upstreamRegistryAsString))
            .setter(setter(Builder::upstreamRegistry))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistry").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt").getter(getter(PullThroughCacheRule::updatedAt)).setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD,
            UPSTREAM_REGISTRY_URL_FIELD, CREATED_AT_FIELD, REGISTRY_ID_FIELD, CREDENTIAL_ARN_FIELD, CUSTOM_ROLE_ARN_FIELD,
            UPSTREAM_REPOSITORY_PREFIX_FIELD, UPSTREAM_REGISTRY_FIELD, UPDATED_AT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String ecrRepositoryPrefix;

    private final String upstreamRegistryUrl;

    private final Instant createdAt;

    private final String registryId;

    private final String credentialArn;

    private final String customRoleArn;

    private final String upstreamRepositoryPrefix;

    private final String upstreamRegistry;

    private final Instant updatedAt;

    private PullThroughCacheRule(BuilderImpl builder) {
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.createdAt = builder.createdAt;
        this.registryId = builder.registryId;
        this.credentialArn = builder.credentialArn;
        this.customRoleArn = builder.customRoleArn;
        this.upstreamRepositoryPrefix = builder.upstreamRepositoryPrefix;
        this.upstreamRegistry = builder.upstreamRegistry;
        this.updatedAt = builder.updatedAt;
    }

    /**
     * <p>
     * The Amazon ECR repository prefix associated with the pull through cache rule.
     * </p>
     * 
     * @return The Amazon ECR repository prefix associated with the pull through cache rule.
     */
    public final String ecrRepositoryPrefix() {
        return ecrRepositoryPrefix;
    }

    /**
     * <p>
     * The upstream registry URL associated with the pull through cache rule.
     * </p>
     * 
     * @return The upstream registry URL associated with the pull through cache rule.
     */
    public final String upstreamRegistryUrl() {
        return upstreamRegistryUrl;
    }

    /**
     * <p>
     * The date and time the pull through cache was created.
     * </p>
     * 
     * @return The date and time the pull through cache was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The Amazon Web Services account ID associated with the registry the pull through cache rule is associated with.
     * </p>
     * 
     * @return The Amazon Web Services account ID associated with the registry the pull through cache rule is associated
     *         with.
     */
    public final String registryId() {
        return registryId;
    }

    /**
     * <p>
     * The ARN of the Secrets Manager secret associated with the pull through cache rule.
     * </p>
     * 
     * @return The ARN of the Secrets Manager secret associated with the pull through cache rule.
     */
    public final String credentialArn() {
        return credentialArn;
    }

    /**
     * <p>
     * The ARN of the IAM role associated with the pull through cache rule.
     * </p>
     * 
     * @return The ARN of the IAM role associated with the pull through cache rule.
     */
    public final String customRoleArn() {
        return customRoleArn;
    }

    /**
     * <p>
     * The upstream repository prefix associated with the pull through cache rule.
     * </p>
     * 
     * @return The upstream repository prefix associated with the pull through cache rule.
     */
    public final String upstreamRepositoryPrefix() {
        return upstreamRepositoryPrefix;
    }

    /**
     * <p>
     * The name of the upstream source registry associated with the pull through cache rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upstreamRegistry}
     * will return {@link UpstreamRegistry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #upstreamRegistryAsString}.
     * </p>
     * 
     * @return The name of the upstream source registry associated with the pull through cache rule.
     * @see UpstreamRegistry
     */
    public final UpstreamRegistry upstreamRegistry() {
        return UpstreamRegistry.fromValue(upstreamRegistry);
    }

    /**
     * <p>
     * The name of the upstream source registry associated with the pull through cache rule.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #upstreamRegistry}
     * will return {@link UpstreamRegistry#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #upstreamRegistryAsString}.
     * </p>
     * 
     * @return The name of the upstream source registry associated with the pull through cache rule.
     * @see UpstreamRegistry
     */
    public final String upstreamRegistryAsString() {
        return upstreamRegistry;
    }

    /**
     * <p>
     * The date and time, in JavaScript date format, when the pull through cache rule was last updated.
     * </p>
     * 
     * @return The date and time, in JavaScript date format, when the pull through cache rule was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(registryId());
        hashCode = 31 * hashCode + Objects.hashCode(credentialArn());
        hashCode = 31 * hashCode + Objects.hashCode(customRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(upstreamRegistryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PullThroughCacheRule)) {
            return false;
        }
        PullThroughCacheRule other = (PullThroughCacheRule) obj;
        return Objects.equals(ecrRepositoryPrefix(), other.ecrRepositoryPrefix())
                && Objects.equals(upstreamRegistryUrl(), other.upstreamRegistryUrl())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(registryId(), other.registryId())
                && Objects.equals(credentialArn(), other.credentialArn())
                && Objects.equals(customRoleArn(), other.customRoleArn())
                && Objects.equals(upstreamRepositoryPrefix(), other.upstreamRepositoryPrefix())
                && Objects.equals(upstreamRegistryAsString(), other.upstreamRegistryAsString())
                && Objects.equals(updatedAt(), other.updatedAt());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PullThroughCacheRule").add("EcrRepositoryPrefix", ecrRepositoryPrefix())
                .add("UpstreamRegistryUrl", upstreamRegistryUrl()).add("CreatedAt", createdAt()).add("RegistryId", registryId())
                .add("CredentialArn", credentialArn()).add("CustomRoleArn", customRoleArn())
                .add("UpstreamRepositoryPrefix", upstreamRepositoryPrefix()).add("UpstreamRegistry", upstreamRegistryAsString())
                .add("UpdatedAt", updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ecrRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(ecrRepositoryPrefix()));
        case "upstreamRegistryUrl":
            return Optional.ofNullable(clazz.cast(upstreamRegistryUrl()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "registryId":
            return Optional.ofNullable(clazz.cast(registryId()));
        case "credentialArn":
            return Optional.ofNullable(clazz.cast(credentialArn()));
        case "customRoleArn":
            return Optional.ofNullable(clazz.cast(customRoleArn()));
        case "upstreamRepositoryPrefix":
            return Optional.ofNullable(clazz.cast(upstreamRepositoryPrefix()));
        case "upstreamRegistry":
            return Optional.ofNullable(clazz.cast(upstreamRegistryAsString()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        map.put("customRoleArn", CUSTOM_ROLE_ARN_FIELD);
        map.put("upstreamRepositoryPrefix", UPSTREAM_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRegistry", UPSTREAM_REGISTRY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PullThroughCacheRule, T> g) {
        return obj -> g.apply((PullThroughCacheRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PullThroughCacheRule> {
        /**
         * <p>
         * The Amazon ECR repository prefix associated with the pull through cache rule.
         * </p>
         * 
         * @param ecrRepositoryPrefix
         *        The Amazon ECR repository prefix associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecrRepositoryPrefix(String ecrRepositoryPrefix);

        /**
         * <p>
         * The upstream registry URL associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRegistryUrl
         *        The upstream registry URL associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRegistryUrl(String upstreamRegistryUrl);

        /**
         * <p>
         * The date and time the pull through cache was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the pull through cache was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The Amazon Web Services account ID associated with the registry the pull through cache rule is associated
         * with.
         * </p>
         * 
         * @param registryId
         *        The Amazon Web Services account ID associated with the registry the pull through cache rule is
         *        associated with.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder registryId(String registryId);

        /**
         * <p>
         * The ARN of the Secrets Manager secret associated with the pull through cache rule.
         * </p>
         * 
         * @param credentialArn
         *        The ARN of the Secrets Manager secret associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentialArn(String credentialArn);

        /**
         * <p>
         * The ARN of the IAM role associated with the pull through cache rule.
         * </p>
         * 
         * @param customRoleArn
         *        The ARN of the IAM role associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customRoleArn(String customRoleArn);

        /**
         * <p>
         * The upstream repository prefix associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRepositoryPrefix
         *        The upstream repository prefix associated with the pull through cache rule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix);

        /**
         * <p>
         * The name of the upstream source registry associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRegistry
         *        The name of the upstream source registry associated with the pull through cache rule.
         * @see UpstreamRegistry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpstreamRegistry
         */
        Builder upstreamRegistry(String upstreamRegistry);

        /**
         * <p>
         * The name of the upstream source registry associated with the pull through cache rule.
         * </p>
         * 
         * @param upstreamRegistry
         *        The name of the upstream source registry associated with the pull through cache rule.
         * @see UpstreamRegistry
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpstreamRegistry
         */
        Builder upstreamRegistry(UpstreamRegistry upstreamRegistry);

        /**
         * <p>
         * The date and time, in JavaScript date format, when the pull through cache rule was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time, in JavaScript date format, when the pull through cache rule was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);
    }

    static final class BuilderImpl implements Builder {
        private String ecrRepositoryPrefix;

        private String upstreamRegistryUrl;

        private Instant createdAt;

        private String registryId;

        private String credentialArn;

        private String customRoleArn;

        private String upstreamRepositoryPrefix;

        private String upstreamRegistry;

        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(PullThroughCacheRule model) {
            ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            upstreamRegistryUrl(model.upstreamRegistryUrl);
            createdAt(model.createdAt);
            registryId(model.registryId);
            credentialArn(model.credentialArn);
            customRoleArn(model.customRoleArn);
            upstreamRepositoryPrefix(model.upstreamRepositoryPrefix);
            upstreamRegistry(model.upstreamRegistry);
            updatedAt(model.updatedAt);
        }

        public final String getEcrRepositoryPrefix() {
            return ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getRegistryId() {
            return registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getCredentialArn() {
            return credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        public final String getCustomRoleArn() {
            return customRoleArn;
        }

        public final void setCustomRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
        }

        @Override
        public final Builder customRoleArn(String customRoleArn) {
            this.customRoleArn = customRoleArn;
            return this;
        }

        public final String getUpstreamRepositoryPrefix() {
            return upstreamRepositoryPrefix;
        }

        public final void setUpstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
        }

        @Override
        public final Builder upstreamRepositoryPrefix(String upstreamRepositoryPrefix) {
            this.upstreamRepositoryPrefix = upstreamRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRegistry() {
            return upstreamRegistry;
        }

        public final void setUpstreamRegistry(String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
        }

        @Override
        public final Builder upstreamRegistry(String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
            return this;
        }

        @Override
        public final Builder upstreamRegistry(UpstreamRegistry upstreamRegistry) {
            this.upstreamRegistry(upstreamRegistry == null ? null : upstreamRegistry.toString());
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        @Override
        public PullThroughCacheRule build() {
            return new PullThroughCacheRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
