/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoryCreationTemplatesResponse;
import software.amazon.awssdk.services.ecr.model.RepositoryCreationTemplate;

public class DescribeRepositoryCreationTemplatesIterable
implements SdkIterable<DescribeRepositoryCreationTemplatesResponse> {
    private final EcrClient client;
    private final DescribeRepositoryCreationTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeRepositoryCreationTemplatesIterable(EcrClient client, DescribeRepositoryCreationTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeRepositoryCreationTemplatesResponseFetcher();
    }

    public Iterator<DescribeRepositoryCreationTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<RepositoryCreationTemplate> repositoryCreationTemplates() {
        Function<DescribeRepositoryCreationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.repositoryCreationTemplates() != null) {
                return response.repositoryCreationTemplates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeRepositoryCreationTemplatesResponseFetcher
    implements SyncPageFetcher<DescribeRepositoryCreationTemplatesResponse> {
        private DescribeRepositoryCreationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRepositoryCreationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeRepositoryCreationTemplatesResponse nextPage(DescribeRepositoryCreationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRepositoryCreationTemplatesIterable.this.client.describeRepositoryCreationTemplates(DescribeRepositoryCreationTemplatesIterable.this.firstRequest);
            }
            return DescribeRepositoryCreationTemplatesIterable.this.client.describeRepositoryCreationTemplates((DescribeRepositoryCreationTemplatesRequest)((Object)DescribeRepositoryCreationTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

