/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ListImagesRequest;
import software.amazon.awssdk.services.ecr.model.ListImagesResponse;

public class ListImagesIterable
implements SdkIterable<ListImagesResponse> {
    private final EcrClient client;
    private final ListImagesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListImagesIterable(EcrClient client, ListImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListImagesResponseFetcher();
    }

    public Iterator<ListImagesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ImageIdentifier> imageIds() {
        Function<ListImagesResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageIds() != null) {
                return response.imageIds().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListImagesResponseFetcher
    implements SyncPageFetcher<ListImagesResponse> {
        private ListImagesResponseFetcher() {
        }

        public boolean hasNextPage(ListImagesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListImagesResponse nextPage(ListImagesResponse previousPage) {
            if (previousPage == null) {
                return ListImagesIterable.this.client.listImages(ListImagesIterable.this.firstRequest);
            }
            return ListImagesIterable.this.client.listImages((ListImagesRequest)((Object)ListImagesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

