/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.UpstreamRegistry;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreatePullThroughCacheRuleRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, CreatePullThroughCacheRuleRequest> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecrRepositoryPrefix").getter(CreatePullThroughCacheRuleRequest.getter(CreatePullThroughCacheRuleRequest::ecrRepositoryPrefix)).setter(CreatePullThroughCacheRuleRequest.setter(Builder::ecrRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build()}).build();
    private static final SdkField<String> UPSTREAM_REGISTRY_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstreamRegistryUrl").getter(CreatePullThroughCacheRuleRequest.getter(CreatePullThroughCacheRuleRequest::upstreamRegistryUrl)).setter(CreatePullThroughCacheRuleRequest.setter(Builder::upstreamRegistryUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistryUrl").build()}).build();
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(CreatePullThroughCacheRuleRequest.getter(CreatePullThroughCacheRuleRequest::registryId)).setter(CreatePullThroughCacheRuleRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> UPSTREAM_REGISTRY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("upstreamRegistry").getter(CreatePullThroughCacheRuleRequest.getter(CreatePullThroughCacheRuleRequest::upstreamRegistryAsString)).setter(CreatePullThroughCacheRuleRequest.setter(Builder::upstreamRegistry)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("upstreamRegistry").build()}).build();
    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialArn").getter(CreatePullThroughCacheRuleRequest.getter(CreatePullThroughCacheRuleRequest::credentialArn)).setter(CreatePullThroughCacheRuleRequest.setter(Builder::credentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD, UPSTREAM_REGISTRY_URL_FIELD, REGISTRY_ID_FIELD, UPSTREAM_REGISTRY_FIELD, CREDENTIAL_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreatePullThroughCacheRuleRequest.memberNameToFieldInitializer();
    private final String ecrRepositoryPrefix;
    private final String upstreamRegistryUrl;
    private final String registryId;
    private final String upstreamRegistry;
    private final String credentialArn;

    private CreatePullThroughCacheRuleRequest(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.upstreamRegistryUrl = builder.upstreamRegistryUrl;
        this.registryId = builder.registryId;
        this.upstreamRegistry = builder.upstreamRegistry;
        this.credentialArn = builder.credentialArn;
    }

    public final String ecrRepositoryPrefix() {
        return this.ecrRepositoryPrefix;
    }

    public final String upstreamRegistryUrl() {
        return this.upstreamRegistryUrl;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final UpstreamRegistry upstreamRegistry() {
        return UpstreamRegistry.fromValue(this.upstreamRegistry);
    }

    public final String upstreamRegistryAsString() {
        return this.upstreamRegistry;
    }

    public final String credentialArn() {
        return this.credentialArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamRegistryUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.upstreamRegistryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePullThroughCacheRuleRequest)) {
            return false;
        }
        CreatePullThroughCacheRuleRequest other = (CreatePullThroughCacheRuleRequest)((Object)obj);
        return Objects.equals(this.ecrRepositoryPrefix(), other.ecrRepositoryPrefix()) && Objects.equals(this.upstreamRegistryUrl(), other.upstreamRegistryUrl()) && Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.upstreamRegistryAsString(), other.upstreamRegistryAsString()) && Objects.equals(this.credentialArn(), other.credentialArn());
    }

    public final String toString() {
        return ToString.builder((String)"CreatePullThroughCacheRuleRequest").add("EcrRepositoryPrefix", (Object)this.ecrRepositoryPrefix()).add("UpstreamRegistryUrl", (Object)this.upstreamRegistryUrl()).add("RegistryId", (Object)this.registryId()).add("UpstreamRegistry", (Object)this.upstreamRegistryAsString()).add("CredentialArn", (Object)this.credentialArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ecrRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryPrefix()));
            }
            case "upstreamRegistryUrl": {
                return Optional.ofNullable(clazz.cast(this.upstreamRegistryUrl()));
            }
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "upstreamRegistry": {
                return Optional.ofNullable(clazz.cast(this.upstreamRegistryAsString()));
            }
            case "credentialArn": {
                return Optional.ofNullable(clazz.cast(this.credentialArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("ecrRepositoryPrefix", ECR_REPOSITORY_PREFIX_FIELD);
        map.put("upstreamRegistryUrl", UPSTREAM_REGISTRY_URL_FIELD);
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("upstreamRegistry", UPSTREAM_REGISTRY_FIELD);
        map.put("credentialArn", CREDENTIAL_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePullThroughCacheRuleRequest, T> g) {
        return obj -> g.apply((CreatePullThroughCacheRuleRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String ecrRepositoryPrefix;
        private String upstreamRegistryUrl;
        private String registryId;
        private String upstreamRegistry;
        private String credentialArn;

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePullThroughCacheRuleRequest model) {
            super(model);
            this.ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            this.upstreamRegistryUrl(model.upstreamRegistryUrl);
            this.registryId(model.registryId);
            this.upstreamRegistry(model.upstreamRegistry);
            this.credentialArn(model.credentialArn);
        }

        public final String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getUpstreamRegistryUrl() {
            return this.upstreamRegistryUrl;
        }

        public final void setUpstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
        }

        @Override
        public final Builder upstreamRegistryUrl(String upstreamRegistryUrl) {
            this.upstreamRegistryUrl = upstreamRegistryUrl;
            return this;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getUpstreamRegistry() {
            return this.upstreamRegistry;
        }

        public final void setUpstreamRegistry(String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
        }

        @Override
        public final Builder upstreamRegistry(String upstreamRegistry) {
            this.upstreamRegistry = upstreamRegistry;
            return this;
        }

        @Override
        public final Builder upstreamRegistry(UpstreamRegistry upstreamRegistry) {
            this.upstreamRegistry(upstreamRegistry == null ? null : upstreamRegistry.toString());
            return this;
        }

        public final String getCredentialArn() {
            return this.credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePullThroughCacheRuleRequest build() {
            return new CreatePullThroughCacheRuleRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreatePullThroughCacheRuleRequest> {
        public Builder ecrRepositoryPrefix(String var1);

        public Builder upstreamRegistryUrl(String var1);

        public Builder registryId(String var1);

        public Builder upstreamRegistry(String var1);

        public Builder upstreamRegistry(UpstreamRegistry var1);

        public Builder credentialArn(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

