/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.LifecyclePolicyPreviewStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartLifecyclePolicyPreviewResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, StartLifecyclePolicyPreviewResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(StartLifecyclePolicyPreviewResponse.getter(StartLifecyclePolicyPreviewResponse::registryId)).setter(StartLifecyclePolicyPreviewResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(StartLifecyclePolicyPreviewResponse.getter(StartLifecyclePolicyPreviewResponse::repositoryName)).setter(StartLifecyclePolicyPreviewResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> LIFECYCLE_POLICY_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecyclePolicyText").getter(StartLifecyclePolicyPreviewResponse.getter(StartLifecyclePolicyPreviewResponse::lifecyclePolicyText)).setter(StartLifecyclePolicyPreviewResponse.setter(Builder::lifecyclePolicyText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecyclePolicyText").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(StartLifecyclePolicyPreviewResponse.getter(StartLifecyclePolicyPreviewResponse::statusAsString)).setter(StartLifecyclePolicyPreviewResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, LIFECYCLE_POLICY_TEXT_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = StartLifecyclePolicyPreviewResponse.memberNameToFieldInitializer();
    private final String registryId;
    private final String repositoryName;
    private final String lifecyclePolicyText;
    private final String status;

    private StartLifecyclePolicyPreviewResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.lifecyclePolicyText = builder.lifecyclePolicyText;
        this.status = builder.status;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String lifecyclePolicyText() {
        return this.lifecyclePolicyText;
    }

    public final LifecyclePolicyPreviewStatus status() {
        return LifecyclePolicyPreviewStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecyclePolicyText());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartLifecyclePolicyPreviewResponse)) {
            return false;
        }
        StartLifecyclePolicyPreviewResponse other = (StartLifecyclePolicyPreviewResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.lifecyclePolicyText(), other.lifecyclePolicyText()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"StartLifecyclePolicyPreviewResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("LifecyclePolicyText", (Object)this.lifecyclePolicyText()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "lifecyclePolicyText": {
                return Optional.ofNullable(clazz.cast(this.lifecyclePolicyText()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("registryId", REGISTRY_ID_FIELD);
        map.put("repositoryName", REPOSITORY_NAME_FIELD);
        map.put("lifecyclePolicyText", LIFECYCLE_POLICY_TEXT_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartLifecyclePolicyPreviewResponse, T> g) {
        return obj -> g.apply((StartLifecyclePolicyPreviewResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String lifecyclePolicyText;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(StartLifecyclePolicyPreviewResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.lifecyclePolicyText(model.lifecyclePolicyText);
            this.status(model.status);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getLifecyclePolicyText() {
            return this.lifecyclePolicyText;
        }

        public final void setLifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
        }

        @Override
        public final Builder lifecyclePolicyText(String lifecyclePolicyText) {
            this.lifecyclePolicyText = lifecyclePolicyText;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LifecyclePolicyPreviewStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public StartLifecyclePolicyPreviewResponse build() {
            return new StartLifecyclePolicyPreviewResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartLifecyclePolicyPreviewResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder lifecyclePolicyText(String var1);

        public Builder status(String var1);

        public Builder status(LifecyclePolicyPreviewStatus var1);
    }
}

