/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.CvssScoreAdjustment;
import software.amazon.awssdk.services.ecr.model.CvssScoreAdjustmentListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CvssScoreDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CvssScoreDetails> {
    private static final SdkField<List<CvssScoreAdjustment>> ADJUSTMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("adjustments").getter(CvssScoreDetails.getter(CvssScoreDetails::adjustments)).setter(CvssScoreDetails.setter(Builder::adjustments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("adjustments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CvssScoreAdjustment::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Double> SCORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOUBLE).memberName("score").getter(CvssScoreDetails.getter(CvssScoreDetails::score)).setter(CvssScoreDetails.setter(Builder::score)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("score").build()}).build();
    private static final SdkField<String> SCORE_SOURCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scoreSource").getter(CvssScoreDetails.getter(CvssScoreDetails::scoreSource)).setter(CvssScoreDetails.setter(Builder::scoreSource)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoreSource").build()}).build();
    private static final SdkField<String> SCORING_VECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("scoringVector").getter(CvssScoreDetails.getter(CvssScoreDetails::scoringVector)).setter(CvssScoreDetails.setter(Builder::scoringVector)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("scoringVector").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(CvssScoreDetails.getter(CvssScoreDetails::version)).setter(CvssScoreDetails.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADJUSTMENTS_FIELD, SCORE_FIELD, SCORE_SOURCE_FIELD, SCORING_VECTOR_FIELD, VERSION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CvssScoreDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<CvssScoreAdjustment> adjustments;
    private final Double score;
    private final String scoreSource;
    private final String scoringVector;
    private final String version;

    private CvssScoreDetails(BuilderImpl builder) {
        this.adjustments = builder.adjustments;
        this.score = builder.score;
        this.scoreSource = builder.scoreSource;
        this.scoringVector = builder.scoringVector;
        this.version = builder.version;
    }

    public final boolean hasAdjustments() {
        return this.adjustments != null && !(this.adjustments instanceof SdkAutoConstructList);
    }

    public final List<CvssScoreAdjustment> adjustments() {
        return this.adjustments;
    }

    public final Double score() {
        return this.score;
    }

    public final String scoreSource() {
        return this.scoreSource;
    }

    public final String scoringVector() {
        return this.scoringVector;
    }

    public final String version() {
        return this.version;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdjustments() ? this.adjustments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.score());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoreSource());
        hashCode = 31 * hashCode + Objects.hashCode(this.scoringVector());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CvssScoreDetails)) {
            return false;
        }
        CvssScoreDetails other = (CvssScoreDetails)obj;
        return this.hasAdjustments() == other.hasAdjustments() && Objects.equals(this.adjustments(), other.adjustments()) && Objects.equals(this.score(), other.score()) && Objects.equals(this.scoreSource(), other.scoreSource()) && Objects.equals(this.scoringVector(), other.scoringVector()) && Objects.equals(this.version(), other.version());
    }

    public final String toString() {
        return ToString.builder((String)"CvssScoreDetails").add("Adjustments", this.hasAdjustments() ? this.adjustments() : null).add("Score", (Object)this.score()).add("ScoreSource", (Object)this.scoreSource()).add("ScoringVector", (Object)this.scoringVector()).add("Version", (Object)this.version()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "adjustments": {
                return Optional.ofNullable(clazz.cast(this.adjustments()));
            }
            case "score": {
                return Optional.ofNullable(clazz.cast(this.score()));
            }
            case "scoreSource": {
                return Optional.ofNullable(clazz.cast(this.scoreSource()));
            }
            case "scoringVector": {
                return Optional.ofNullable(clazz.cast(this.scoringVector()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("adjustments", ADJUSTMENTS_FIELD);
        map.put("score", SCORE_FIELD);
        map.put("scoreSource", SCORE_SOURCE_FIELD);
        map.put("scoringVector", SCORING_VECTOR_FIELD);
        map.put("version", VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CvssScoreDetails, T> g) {
        return obj -> g.apply((CvssScoreDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<CvssScoreAdjustment> adjustments = DefaultSdkAutoConstructList.getInstance();
        private Double score;
        private String scoreSource;
        private String scoringVector;
        private String version;

        private BuilderImpl() {
        }

        private BuilderImpl(CvssScoreDetails model) {
            this.adjustments(model.adjustments);
            this.score(model.score);
            this.scoreSource(model.scoreSource);
            this.scoringVector(model.scoringVector);
            this.version(model.version);
        }

        public final List<CvssScoreAdjustment.Builder> getAdjustments() {
            List<CvssScoreAdjustment.Builder> result = CvssScoreAdjustmentListCopier.copyToBuilder(this.adjustments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdjustments(Collection<CvssScoreAdjustment.BuilderImpl> adjustments) {
            this.adjustments = CvssScoreAdjustmentListCopier.copyFromBuilder(adjustments);
        }

        @Override
        public final Builder adjustments(Collection<CvssScoreAdjustment> adjustments) {
            this.adjustments = CvssScoreAdjustmentListCopier.copy(adjustments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustments(CvssScoreAdjustment ... adjustments) {
            this.adjustments(Arrays.asList(adjustments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder adjustments(Consumer<CvssScoreAdjustment.Builder> ... adjustments) {
            this.adjustments(Stream.of(adjustments).map(c -> (CvssScoreAdjustment)((CvssScoreAdjustment.Builder)CvssScoreAdjustment.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Double getScore() {
            return this.score;
        }

        public final void setScore(Double score) {
            this.score = score;
        }

        @Override
        public final Builder score(Double score) {
            this.score = score;
            return this;
        }

        public final String getScoreSource() {
            return this.scoreSource;
        }

        public final void setScoreSource(String scoreSource) {
            this.scoreSource = scoreSource;
        }

        @Override
        public final Builder scoreSource(String scoreSource) {
            this.scoreSource = scoreSource;
            return this;
        }

        public final String getScoringVector() {
            return this.scoringVector;
        }

        public final void setScoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
        }

        @Override
        public final Builder scoringVector(String scoringVector) {
            this.scoringVector = scoringVector;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public CvssScoreDetails build() {
            return new CvssScoreDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CvssScoreDetails> {
        public Builder adjustments(Collection<CvssScoreAdjustment> var1);

        public Builder adjustments(CvssScoreAdjustment ... var1);

        public Builder adjustments(Consumer<CvssScoreAdjustment.Builder> ... var1);

        public Builder score(Double var1);

        public Builder scoreSource(String var1);

        public Builder scoringVector(String var1);

        public Builder version(String var1);
    }
}

