/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EncryptionConfiguration;
import software.amazon.awssdk.services.ecr.model.ImageScanningConfiguration;
import software.amazon.awssdk.services.ecr.model.ImageTagMutability;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Repository
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Repository> {
    private static final SdkField<String> REPOSITORY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryArn").getter(Repository.getter(Repository::repositoryArn)).setter(Repository.setter(Builder::repositoryArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryArn").build()}).build();
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(Repository.getter(Repository::registryId)).setter(Repository.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(Repository.getter(Repository::repositoryName)).setter(Repository.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> REPOSITORY_URI_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryUri").getter(Repository.getter(Repository::repositoryUri)).setter(Repository.setter(Builder::repositoryUri)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryUri").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(Repository.getter(Repository::createdAt)).setter(Repository.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> IMAGE_TAG_MUTABILITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("imageTagMutability").getter(Repository.getter(Repository::imageTagMutabilityAsString)).setter(Repository.setter(Builder::imageTagMutability)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTagMutability").build()}).build();
    private static final SdkField<ImageScanningConfiguration> IMAGE_SCANNING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanningConfiguration").getter(Repository.getter(Repository::imageScanningConfiguration)).setter(Repository.setter(Builder::imageScanningConfiguration)).constructor(ImageScanningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanningConfiguration").build()}).build();
    private static final SdkField<EncryptionConfiguration> ENCRYPTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("encryptionConfiguration").getter(Repository.getter(Repository::encryptionConfiguration)).setter(Repository.setter(Builder::encryptionConfiguration)).constructor(EncryptionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("encryptionConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REPOSITORY_ARN_FIELD, REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, REPOSITORY_URI_FIELD, CREATED_AT_FIELD, IMAGE_TAG_MUTABILITY_FIELD, IMAGE_SCANNING_CONFIGURATION_FIELD, ENCRYPTION_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("repositoryArn", REPOSITORY_ARN_FIELD);
            this.put("registryId", REGISTRY_ID_FIELD);
            this.put("repositoryName", REPOSITORY_NAME_FIELD);
            this.put("repositoryUri", REPOSITORY_URI_FIELD);
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("imageTagMutability", IMAGE_TAG_MUTABILITY_FIELD);
            this.put("imageScanningConfiguration", IMAGE_SCANNING_CONFIGURATION_FIELD);
            this.put("encryptionConfiguration", ENCRYPTION_CONFIGURATION_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String repositoryArn;
    private final String registryId;
    private final String repositoryName;
    private final String repositoryUri;
    private final Instant createdAt;
    private final String imageTagMutability;
    private final ImageScanningConfiguration imageScanningConfiguration;
    private final EncryptionConfiguration encryptionConfiguration;

    private Repository(BuilderImpl builder) {
        this.repositoryArn = builder.repositoryArn;
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.repositoryUri = builder.repositoryUri;
        this.createdAt = builder.createdAt;
        this.imageTagMutability = builder.imageTagMutability;
        this.imageScanningConfiguration = builder.imageScanningConfiguration;
        this.encryptionConfiguration = builder.encryptionConfiguration;
    }

    public final String repositoryArn() {
        return this.repositoryArn;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final String repositoryUri() {
        return this.repositoryUri;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final ImageTagMutability imageTagMutability() {
        return ImageTagMutability.fromValue(this.imageTagMutability);
    }

    public final String imageTagMutabilityAsString() {
        return this.imageTagMutability;
    }

    public final ImageScanningConfiguration imageScanningConfiguration() {
        return this.imageScanningConfiguration;
    }

    public final EncryptionConfiguration encryptionConfiguration() {
        return this.encryptionConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryUri());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTagMutabilityAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanningConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Repository)) {
            return false;
        }
        Repository other = (Repository)obj;
        return Objects.equals(this.repositoryArn(), other.repositoryArn()) && Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.repositoryUri(), other.repositoryUri()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.imageTagMutabilityAsString(), other.imageTagMutabilityAsString()) && Objects.equals(this.imageScanningConfiguration(), other.imageScanningConfiguration()) && Objects.equals(this.encryptionConfiguration(), other.encryptionConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"Repository").add("RepositoryArn", (Object)this.repositoryArn()).add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("RepositoryUri", (Object)this.repositoryUri()).add("CreatedAt", (Object)this.createdAt()).add("ImageTagMutability", (Object)this.imageTagMutabilityAsString()).add("ImageScanningConfiguration", (Object)this.imageScanningConfiguration()).add("EncryptionConfiguration", (Object)this.encryptionConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryArn": {
                return Optional.ofNullable(clazz.cast(this.repositoryArn()));
            }
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "repositoryUri": {
                return Optional.ofNullable(clazz.cast(this.repositoryUri()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "imageTagMutability": {
                return Optional.ofNullable(clazz.cast(this.imageTagMutabilityAsString()));
            }
            case "imageScanningConfiguration": {
                return Optional.ofNullable(clazz.cast(this.imageScanningConfiguration()));
            }
            case "encryptionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.encryptionConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Repository, T> g) {
        return obj -> g.apply((Repository)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String repositoryArn;
        private String registryId;
        private String repositoryName;
        private String repositoryUri;
        private Instant createdAt;
        private String imageTagMutability;
        private ImageScanningConfiguration imageScanningConfiguration;
        private EncryptionConfiguration encryptionConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Repository model) {
            this.repositoryArn(model.repositoryArn);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.repositoryUri(model.repositoryUri);
            this.createdAt(model.createdAt);
            this.imageTagMutability(model.imageTagMutability);
            this.imageScanningConfiguration(model.imageScanningConfiguration);
            this.encryptionConfiguration(model.encryptionConfiguration);
        }

        public final String getRepositoryArn() {
            return this.repositoryArn;
        }

        public final void setRepositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
        }

        @Override
        public final Builder repositoryArn(String repositoryArn) {
            this.repositoryArn = repositoryArn;
            return this;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final String getRepositoryUri() {
            return this.repositoryUri;
        }

        public final void setRepositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
        }

        @Override
        public final Builder repositoryUri(String repositoryUri) {
            this.repositoryUri = repositoryUri;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getImageTagMutability() {
            return this.imageTagMutability;
        }

        public final void setImageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
        }

        @Override
        public final Builder imageTagMutability(String imageTagMutability) {
            this.imageTagMutability = imageTagMutability;
            return this;
        }

        @Override
        public final Builder imageTagMutability(ImageTagMutability imageTagMutability) {
            this.imageTagMutability(imageTagMutability == null ? null : imageTagMutability.toString());
            return this;
        }

        public final ImageScanningConfiguration.Builder getImageScanningConfiguration() {
            return this.imageScanningConfiguration != null ? this.imageScanningConfiguration.toBuilder() : null;
        }

        public final void setImageScanningConfiguration(ImageScanningConfiguration.BuilderImpl imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration != null ? imageScanningConfiguration.build() : null;
        }

        @Override
        public final Builder imageScanningConfiguration(ImageScanningConfiguration imageScanningConfiguration) {
            this.imageScanningConfiguration = imageScanningConfiguration;
            return this;
        }

        public final EncryptionConfiguration.Builder getEncryptionConfiguration() {
            return this.encryptionConfiguration != null ? this.encryptionConfiguration.toBuilder() : null;
        }

        public final void setEncryptionConfiguration(EncryptionConfiguration.BuilderImpl encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration != null ? encryptionConfiguration.build() : null;
        }

        @Override
        public final Builder encryptionConfiguration(EncryptionConfiguration encryptionConfiguration) {
            this.encryptionConfiguration = encryptionConfiguration;
            return this;
        }

        public Repository build() {
            return new Repository(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Repository> {
        public Builder repositoryArn(String var1);

        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder repositoryUri(String var1);

        public Builder createdAt(Instant var1);

        public Builder imageTagMutability(String var1);

        public Builder imageTagMutability(ImageTagMutability var1);

        public Builder imageScanningConfiguration(ImageScanningConfiguration var1);

        default public Builder imageScanningConfiguration(Consumer<ImageScanningConfiguration.Builder> imageScanningConfiguration) {
            return this.imageScanningConfiguration((ImageScanningConfiguration)((ImageScanningConfiguration.Builder)ImageScanningConfiguration.builder().applyMutation(imageScanningConfiguration)).build());
        }

        public Builder encryptionConfiguration(EncryptionConfiguration var1);

        default public Builder encryptionConfiguration(Consumer<EncryptionConfiguration.Builder> encryptionConfiguration) {
            return this.encryptionConfiguration((EncryptionConfiguration)((EncryptionConfiguration.Builder)EncryptionConfiguration.builder().applyMutation(encryptionConfiguration)).build());
        }
    }
}

