/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.ecr.model.FindingSeverity;
import software.amazon.awssdk.services.ecr.model.FindingSeverityCountsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ImageScanFindingsSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ImageScanFindingsSummary> {
    private static final SdkField<Instant> IMAGE_SCAN_COMPLETED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("imageScanCompletedAt").getter(ImageScanFindingsSummary.getter(ImageScanFindingsSummary::imageScanCompletedAt)).setter(ImageScanFindingsSummary.setter(Builder::imageScanCompletedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanCompletedAt").build()}).build();
    private static final SdkField<Instant> VULNERABILITY_SOURCE_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("vulnerabilitySourceUpdatedAt").getter(ImageScanFindingsSummary.getter(ImageScanFindingsSummary::vulnerabilitySourceUpdatedAt)).setter(ImageScanFindingsSummary.setter(Builder::vulnerabilitySourceUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vulnerabilitySourceUpdatedAt").build()}).build();
    private static final SdkField<Map<String, Integer>> FINDING_SEVERITY_COUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("findingSeverityCounts").getter(ImageScanFindingsSummary.getter(ImageScanFindingsSummary::findingSeverityCountsAsStrings)).setter(ImageScanFindingsSummary.setter(Builder::findingSeverityCountsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("findingSeverityCounts").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.INTEGER).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_SCAN_COMPLETED_AT_FIELD, VULNERABILITY_SOURCE_UPDATED_AT_FIELD, FINDING_SEVERITY_COUNTS_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant imageScanCompletedAt;
    private final Instant vulnerabilitySourceUpdatedAt;
    private final Map<String, Integer> findingSeverityCounts;

    private ImageScanFindingsSummary(BuilderImpl builder) {
        this.imageScanCompletedAt = builder.imageScanCompletedAt;
        this.vulnerabilitySourceUpdatedAt = builder.vulnerabilitySourceUpdatedAt;
        this.findingSeverityCounts = builder.findingSeverityCounts;
    }

    public final Instant imageScanCompletedAt() {
        return this.imageScanCompletedAt;
    }

    public final Instant vulnerabilitySourceUpdatedAt() {
        return this.vulnerabilitySourceUpdatedAt;
    }

    public final Map<FindingSeverity, Integer> findingSeverityCounts() {
        return FindingSeverityCountsCopier.copyStringToEnum(this.findingSeverityCounts);
    }

    public final boolean hasFindingSeverityCounts() {
        return this.findingSeverityCounts != null && !(this.findingSeverityCounts instanceof SdkAutoConstructMap);
    }

    public final Map<String, Integer> findingSeverityCountsAsStrings() {
        return this.findingSeverityCounts;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanCompletedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.vulnerabilitySourceUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFindingSeverityCounts() ? this.findingSeverityCountsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageScanFindingsSummary)) {
            return false;
        }
        ImageScanFindingsSummary other = (ImageScanFindingsSummary)obj;
        return Objects.equals(this.imageScanCompletedAt(), other.imageScanCompletedAt()) && Objects.equals(this.vulnerabilitySourceUpdatedAt(), other.vulnerabilitySourceUpdatedAt()) && this.hasFindingSeverityCounts() == other.hasFindingSeverityCounts() && Objects.equals(this.findingSeverityCountsAsStrings(), other.findingSeverityCountsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"ImageScanFindingsSummary").add("ImageScanCompletedAt", (Object)this.imageScanCompletedAt()).add("VulnerabilitySourceUpdatedAt", (Object)this.vulnerabilitySourceUpdatedAt()).add("FindingSeverityCounts", this.hasFindingSeverityCounts() ? this.findingSeverityCountsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageScanCompletedAt": {
                return Optional.ofNullable(clazz.cast(this.imageScanCompletedAt()));
            }
            case "vulnerabilitySourceUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.vulnerabilitySourceUpdatedAt()));
            }
            case "findingSeverityCounts": {
                return Optional.ofNullable(clazz.cast(this.findingSeverityCountsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ImageScanFindingsSummary, T> g) {
        return obj -> g.apply((ImageScanFindingsSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant imageScanCompletedAt;
        private Instant vulnerabilitySourceUpdatedAt;
        private Map<String, Integer> findingSeverityCounts = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ImageScanFindingsSummary model) {
            this.imageScanCompletedAt(model.imageScanCompletedAt);
            this.vulnerabilitySourceUpdatedAt(model.vulnerabilitySourceUpdatedAt);
            this.findingSeverityCountsWithStrings(model.findingSeverityCounts);
        }

        public final Instant getImageScanCompletedAt() {
            return this.imageScanCompletedAt;
        }

        public final void setImageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
        }

        @Override
        public final Builder imageScanCompletedAt(Instant imageScanCompletedAt) {
            this.imageScanCompletedAt = imageScanCompletedAt;
            return this;
        }

        public final Instant getVulnerabilitySourceUpdatedAt() {
            return this.vulnerabilitySourceUpdatedAt;
        }

        public final void setVulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
        }

        @Override
        public final Builder vulnerabilitySourceUpdatedAt(Instant vulnerabilitySourceUpdatedAt) {
            this.vulnerabilitySourceUpdatedAt = vulnerabilitySourceUpdatedAt;
            return this;
        }

        public final Map<String, Integer> getFindingSeverityCounts() {
            if (this.findingSeverityCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.findingSeverityCounts;
        }

        public final void setFindingSeverityCounts(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
        }

        @Override
        public final Builder findingSeverityCountsWithStrings(Map<String, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copy(findingSeverityCounts);
            return this;
        }

        @Override
        public final Builder findingSeverityCounts(Map<FindingSeverity, Integer> findingSeverityCounts) {
            this.findingSeverityCounts = FindingSeverityCountsCopier.copyEnumToString(findingSeverityCounts);
            return this;
        }

        public ImageScanFindingsSummary build() {
            return new ImageScanFindingsSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ImageScanFindingsSummary> {
        public Builder imageScanCompletedAt(Instant var1);

        public Builder vulnerabilitySourceUpdatedAt(Instant var1);

        public Builder findingSeverityCountsWithStrings(Map<String, Integer> var1);

        public Builder findingSeverityCounts(Map<FindingSeverity, Integer> var1);
    }
}

