/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.internal.UserAgentUtils;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.EnhancedImageScanFinding;
import software.amazon.awssdk.services.ecr.model.ImageScanFinding;

public class DescribeImageScanFindingsPublisher
implements SdkPublisher<DescribeImageScanFindingsResponse> {
    private final EcrAsyncClient client;
    private final DescribeImageScanFindingsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeImageScanFindingsPublisher(EcrAsyncClient client, DescribeImageScanFindingsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeImageScanFindingsPublisher(EcrAsyncClient client, DescribeImageScanFindingsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeImageScanFindingsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeImageScanFindingsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImageScanFinding> findings() {
        Function<DescribeImageScanFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageScanFindings() != null && response.imageScanFindings().findings() != null) {
                return response.imageScanFindings().findings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImageScanFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    public final SdkPublisher<EnhancedImageScanFinding> enhancedFindings() {
        Function<DescribeImageScanFindingsResponse, Iterator> getIterator = response -> {
            if (response != null && response.imageScanFindings() != null && response.imageScanFindings().enhancedFindings() != null) {
                return response.imageScanFindings().enhancedFindings().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeImageScanFindingsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeImageScanFindingsResponseFetcher
    implements AsyncPageFetcher<DescribeImageScanFindingsResponse> {
        private DescribeImageScanFindingsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImageScanFindingsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeImageScanFindingsResponse> nextPage(DescribeImageScanFindingsResponse previousPage) {
            if (previousPage == null) {
                return DescribeImageScanFindingsPublisher.this.client.describeImageScanFindings(DescribeImageScanFindingsPublisher.this.firstRequest);
            }
            return DescribeImageScanFindingsPublisher.this.client.describeImageScanFindings((DescribeImageScanFindingsRequest)((Object)DescribeImageScanFindingsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

