/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImageScanFindingsResponse;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewRequest;
import software.amazon.awssdk.services.ecr.model.GetLifecyclePolicyPreviewResponse;
import software.amazon.awssdk.services.ecr.waiters.EcrWaiter;
import software.amazon.awssdk.services.ecr.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultEcrWaiter
implements EcrWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final EcrClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeImageScanFindingsResponse> imageScanCompleteWaiter;
    private final Waiter<GetLifecyclePolicyPreviewResponse> lifecyclePolicyPreviewCompleteWaiter;

    private DefaultEcrWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (EcrClient)EcrClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.imageScanCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImageScanFindingsResponse.class).acceptors(DefaultEcrWaiter.imageScanCompleteWaiterAcceptors())).overrideConfiguration(DefaultEcrWaiter.imageScanCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.lifecyclePolicyPreviewCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetLifecyclePolicyPreviewResponse.class).acceptors(DefaultEcrWaiter.lifecyclePolicyPreviewCompleteWaiterAcceptors())).overrideConfiguration(DefaultEcrWaiter.lifecyclePolicyPreviewCompleteWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeImageScanFindingsResponse> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest) {
        return this.imageScanCompleteWaiter.run(() -> this.client.describeImageScanFindings(this.applyWaitersUserAgent(describeImageScanFindingsRequest)));
    }

    @Override
    public WaiterResponse<DescribeImageScanFindingsResponse> waitUntilImageScanComplete(DescribeImageScanFindingsRequest describeImageScanFindingsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageScanCompleteWaiter.run(() -> this.client.describeImageScanFindings(this.applyWaitersUserAgent(describeImageScanFindingsRequest)), DefaultEcrWaiter.imageScanCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetLifecyclePolicyPreviewResponse> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest) {
        return this.lifecyclePolicyPreviewCompleteWaiter.run(() -> this.client.getLifecyclePolicyPreview(this.applyWaitersUserAgent(getLifecyclePolicyPreviewRequest)));
    }

    @Override
    public WaiterResponse<GetLifecyclePolicyPreviewResponse> waitUntilLifecyclePolicyPreviewComplete(GetLifecyclePolicyPreviewRequest getLifecyclePolicyPreviewRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.lifecyclePolicyPreviewCompleteWaiter.run(() -> this.client.getLifecyclePolicyPreview(this.applyWaitersUserAgent(getLifecyclePolicyPreviewRequest)), DefaultEcrWaiter.lifecyclePolicyPreviewCompleteWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeImageScanFindingsResponse>> imageScanCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImageScanFindingsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImageScanFindingsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("imageScanStatus").field("status").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("imageScanStatus").field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetLifecyclePolicyPreviewResponse>> lifecyclePolicyPreviewCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetLifecyclePolicyPreviewResponse>> result = new ArrayList<WaiterAcceptor<? super GetLifecyclePolicyPreviewResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "COMPLETE");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("status").value(), "FAILED");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration imageScanCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(60);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration lifecyclePolicyPreviewCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(20);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static EcrWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends EcrRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((EcrRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements EcrWaiter.Builder {
        private EcrClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public EcrWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public EcrWaiter.Builder client(EcrClient client) {
            this.client = client;
            return this;
        }

        @Override
        public EcrWaiter build() {
            return new DefaultEcrWaiter(this);
        }
    }
}

