/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePullThroughCacheRuleResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, UpdatePullThroughCacheRuleResponse> {
    private static final SdkField<String> ECR_REPOSITORY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ecrRepositoryPrefix").getter(UpdatePullThroughCacheRuleResponse.getter(UpdatePullThroughCacheRuleResponse::ecrRepositoryPrefix)).setter(UpdatePullThroughCacheRuleResponse.setter(Builder::ecrRepositoryPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecrRepositoryPrefix").build()}).build();
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(UpdatePullThroughCacheRuleResponse.getter(UpdatePullThroughCacheRuleResponse::registryId)).setter(UpdatePullThroughCacheRuleResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(UpdatePullThroughCacheRuleResponse.getter(UpdatePullThroughCacheRuleResponse::updatedAt)).setter(UpdatePullThroughCacheRuleResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> CREDENTIAL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("credentialArn").getter(UpdatePullThroughCacheRuleResponse.getter(UpdatePullThroughCacheRuleResponse::credentialArn)).setter(UpdatePullThroughCacheRuleResponse.setter(Builder::credentialArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ECR_REPOSITORY_PREFIX_FIELD, REGISTRY_ID_FIELD, UPDATED_AT_FIELD, CREDENTIAL_ARN_FIELD));
    private final String ecrRepositoryPrefix;
    private final String registryId;
    private final Instant updatedAt;
    private final String credentialArn;

    private UpdatePullThroughCacheRuleResponse(BuilderImpl builder) {
        super(builder);
        this.ecrRepositoryPrefix = builder.ecrRepositoryPrefix;
        this.registryId = builder.registryId;
        this.updatedAt = builder.updatedAt;
        this.credentialArn = builder.credentialArn;
    }

    public final String ecrRepositoryPrefix() {
        return this.ecrRepositoryPrefix;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String credentialArn() {
        return this.credentialArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.ecrRepositoryPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.credentialArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePullThroughCacheRuleResponse)) {
            return false;
        }
        UpdatePullThroughCacheRuleResponse other = (UpdatePullThroughCacheRuleResponse)((Object)obj);
        return Objects.equals(this.ecrRepositoryPrefix(), other.ecrRepositoryPrefix()) && Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.credentialArn(), other.credentialArn());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePullThroughCacheRuleResponse").add("EcrRepositoryPrefix", (Object)this.ecrRepositoryPrefix()).add("RegistryId", (Object)this.registryId()).add("UpdatedAt", (Object)this.updatedAt()).add("CredentialArn", (Object)this.credentialArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ecrRepositoryPrefix": {
                return Optional.ofNullable(clazz.cast(this.ecrRepositoryPrefix()));
            }
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "credentialArn": {
                return Optional.ofNullable(clazz.cast(this.credentialArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdatePullThroughCacheRuleResponse, T> g) {
        return obj -> g.apply((UpdatePullThroughCacheRuleResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String ecrRepositoryPrefix;
        private String registryId;
        private Instant updatedAt;
        private String credentialArn;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePullThroughCacheRuleResponse model) {
            super(model);
            this.ecrRepositoryPrefix(model.ecrRepositoryPrefix);
            this.registryId(model.registryId);
            this.updatedAt(model.updatedAt);
            this.credentialArn(model.credentialArn);
        }

        public final String getEcrRepositoryPrefix() {
            return this.ecrRepositoryPrefix;
        }

        public final void setEcrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
        }

        @Override
        public final Builder ecrRepositoryPrefix(String ecrRepositoryPrefix) {
            this.ecrRepositoryPrefix = ecrRepositoryPrefix;
            return this;
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getCredentialArn() {
            return this.credentialArn;
        }

        public final void setCredentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
        }

        @Override
        public final Builder credentialArn(String credentialArn) {
            this.credentialArn = credentialArn;
            return this;
        }

        @Override
        public UpdatePullThroughCacheRuleResponse build() {
            return new UpdatePullThroughCacheRuleResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePullThroughCacheRuleResponse> {
        public Builder ecrRepositoryPrefix(String var1);

        public Builder registryId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder credentialArn(String var1);
    }
}

