/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ImageActionType {
    EXPIRE("EXPIRE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ImageActionType> VALUE_MAP;
    private final String value;

    private ImageActionType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ImageActionType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ImageActionType> knownValues() {
        EnumSet<ImageActionType> knownValues = EnumSet.allOf(ImageActionType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ImageActionType.class, ImageActionType::toString);
    }
}

