/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecr.DefaultEcrAsyncClient;
import software.amazon.awssdk.services.ecr.DefaultEcrBaseClientBuilder;
import software.amazon.awssdk.services.ecr.EcrAsyncClient;
import software.amazon.awssdk.services.ecr.EcrAsyncClientBuilder;
import software.amazon.awssdk.services.ecr.EcrServiceClientConfiguration;
import software.amazon.awssdk.services.ecr.endpoints.EcrEndpointProvider;

@SdkInternalApi
final class DefaultEcrAsyncClientBuilder
extends DefaultEcrBaseClientBuilder<EcrAsyncClientBuilder, EcrAsyncClient>
implements EcrAsyncClientBuilder {
    DefaultEcrAsyncClientBuilder() {
    }

    @Override
    public DefaultEcrAsyncClientBuilder endpointProvider(EcrEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EcrAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultEcrAsyncClientBuilder.validateClientOptions(clientConfiguration);
        EcrServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultEcrAsyncClient client = new DefaultEcrAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private EcrServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        if (Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return EcrServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider((EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER)).build();
    }
}

