/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The operation failed due to a KMS exception.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KmsException extends EcrException implements ToCopyableBuilder<KmsException.Builder, KmsException> {
    private static final SdkField<String> KMS_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("kmsError").getter(getter(KmsException::kmsError)).setter(setter(Builder::kmsError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kmsError").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KMS_ERROR_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kmsError;

    private KmsException(BuilderImpl builder) {
        super(builder);
        this.kmsError = builder.kmsError;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The error code returned by KMS.
     * </p>
     * 
     * @return The error code returned by KMS.
     */
    public String kmsError() {
        return kmsError;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<KmsException, T> g) {
        return obj -> g.apply((KmsException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KmsException>, EcrException.Builder {
        /**
         * <p>
         * The error code returned by KMS.
         * </p>
         * 
         * @param kmsError
         *        The error code returned by KMS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsError(String kmsError);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends EcrException.BuilderImpl implements Builder {
        private String kmsError;

        private BuilderImpl() {
        }

        private BuilderImpl(KmsException model) {
            super(model);
            kmsError(model.kmsError);
        }

        public final String getKmsError() {
            return kmsError;
        }

        public final void setKmsError(String kmsError) {
            this.kmsError = kmsError;
        }

        @Override
        public final Builder kmsError(String kmsError) {
            this.kmsError = kmsError;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public KmsException build() {
            return new KmsException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
