/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.ecr.DefaultEcrBaseClientBuilder;
import software.amazon.awssdk.services.ecr.DefaultEcrClient;
import software.amazon.awssdk.services.ecr.EcrClient;
import software.amazon.awssdk.services.ecr.EcrClientBuilder;
import software.amazon.awssdk.services.ecr.EcrServiceClientConfiguration;
import software.amazon.awssdk.services.ecr.endpoints.EcrEndpointProvider;

@SdkInternalApi
final class DefaultEcrClientBuilder
extends DefaultEcrBaseClientBuilder<EcrClientBuilder, EcrClient>
implements EcrClientBuilder {
    DefaultEcrClientBuilder() {
    }

    @Override
    public DefaultEcrClientBuilder endpointProvider(EcrEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final EcrClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultEcrClientBuilder.validateClientOptions(clientConfiguration);
        EcrServiceClientConfiguration serviceClientConfiguration = EcrServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultEcrClient(serviceClientConfiguration, clientConfiguration);
    }
}

