/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.ImageIdentifier;
import software.amazon.awssdk.services.ecr.model.ImageScanFindings;
import software.amazon.awssdk.services.ecr.model.ImageScanStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeImageScanFindingsResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, DescribeImageScanFindingsResponse> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("registryId").getter(DescribeImageScanFindingsResponse.getter(DescribeImageScanFindingsResponse::registryId)).setter(DescribeImageScanFindingsResponse.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("repositoryName").getter(DescribeImageScanFindingsResponse.getter(DescribeImageScanFindingsResponse::repositoryName)).setter(DescribeImageScanFindingsResponse.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<ImageIdentifier> IMAGE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageId").getter(DescribeImageScanFindingsResponse.getter(DescribeImageScanFindingsResponse::imageId)).setter(DescribeImageScanFindingsResponse.setter(Builder::imageId)).constructor(ImageIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageId").build()}).build();
    private static final SdkField<ImageScanStatus> IMAGE_SCAN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanStatus").getter(DescribeImageScanFindingsResponse.getter(DescribeImageScanFindingsResponse::imageScanStatus)).setter(DescribeImageScanFindingsResponse.setter(Builder::imageScanStatus)).constructor(ImageScanStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanStatus").build()}).build();
    private static final SdkField<ImageScanFindings> IMAGE_SCAN_FINDINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("imageScanFindings").getter(DescribeImageScanFindingsResponse.getter(DescribeImageScanFindingsResponse::imageScanFindings)).setter(DescribeImageScanFindingsResponse.setter(Builder::imageScanFindings)).constructor(ImageScanFindings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageScanFindings").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(DescribeImageScanFindingsResponse.getter(DescribeImageScanFindingsResponse::nextToken)).setter(DescribeImageScanFindingsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_ID_FIELD, IMAGE_SCAN_STATUS_FIELD, IMAGE_SCAN_FINDINGS_FIELD, NEXT_TOKEN_FIELD));
    private final String registryId;
    private final String repositoryName;
    private final ImageIdentifier imageId;
    private final ImageScanStatus imageScanStatus;
    private final ImageScanFindings imageScanFindings;
    private final String nextToken;

    private DescribeImageScanFindingsResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageId = builder.imageId;
        this.imageScanStatus = builder.imageScanStatus;
        this.imageScanFindings = builder.imageScanFindings;
        this.nextToken = builder.nextToken;
    }

    public final String registryId() {
        return this.registryId;
    }

    public final String repositoryName() {
        return this.repositoryName;
    }

    public final ImageIdentifier imageId() {
        return this.imageId;
    }

    public final ImageScanStatus imageScanStatus() {
        return this.imageScanStatus;
    }

    public final ImageScanFindings imageScanFindings() {
        return this.imageScanFindings;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageId());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageScanFindings());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImageScanFindingsResponse)) {
            return false;
        }
        DescribeImageScanFindingsResponse other = (DescribeImageScanFindingsResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageId(), other.imageId()) && Objects.equals(this.imageScanStatus(), other.imageScanStatus()) && Objects.equals(this.imageScanFindings(), other.imageScanFindings()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeImageScanFindingsResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageId", (Object)this.imageId()).add("ImageScanStatus", (Object)this.imageScanStatus()).add("ImageScanFindings", (Object)this.imageScanFindings()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageId": {
                return Optional.ofNullable(clazz.cast(this.imageId()));
            }
            case "imageScanStatus": {
                return Optional.ofNullable(clazz.cast(this.imageScanStatus()));
            }
            case "imageScanFindings": {
                return Optional.ofNullable(clazz.cast(this.imageScanFindings()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeImageScanFindingsResponse, T> g) {
        return obj -> g.apply((DescribeImageScanFindingsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private ImageIdentifier imageId;
        private ImageScanStatus imageScanStatus;
        private ImageScanFindings imageScanFindings;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImageScanFindingsResponse model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageId(model.imageId);
            this.imageScanStatus(model.imageScanStatus);
            this.imageScanFindings(model.imageScanFindings);
            this.nextToken(model.nextToken);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final ImageIdentifier.Builder getImageId() {
            return this.imageId != null ? this.imageId.toBuilder() : null;
        }

        public final void setImageId(ImageIdentifier.BuilderImpl imageId) {
            this.imageId = imageId != null ? imageId.build() : null;
        }

        @Override
        public final Builder imageId(ImageIdentifier imageId) {
            this.imageId = imageId;
            return this;
        }

        public final ImageScanStatus.Builder getImageScanStatus() {
            return this.imageScanStatus != null ? this.imageScanStatus.toBuilder() : null;
        }

        public final void setImageScanStatus(ImageScanStatus.BuilderImpl imageScanStatus) {
            this.imageScanStatus = imageScanStatus != null ? imageScanStatus.build() : null;
        }

        @Override
        public final Builder imageScanStatus(ImageScanStatus imageScanStatus) {
            this.imageScanStatus = imageScanStatus;
            return this;
        }

        public final ImageScanFindings.Builder getImageScanFindings() {
            return this.imageScanFindings != null ? this.imageScanFindings.toBuilder() : null;
        }

        public final void setImageScanFindings(ImageScanFindings.BuilderImpl imageScanFindings) {
            this.imageScanFindings = imageScanFindings != null ? imageScanFindings.build() : null;
        }

        @Override
        public final Builder imageScanFindings(ImageScanFindings imageScanFindings) {
            this.imageScanFindings = imageScanFindings;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeImageScanFindingsResponse build() {
            return new DescribeImageScanFindingsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeImageScanFindingsResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageId(ImageIdentifier var1);

        default public Builder imageId(Consumer<ImageIdentifier.Builder> imageId) {
            return this.imageId((ImageIdentifier)((ImageIdentifier.Builder)ImageIdentifier.builder().applyMutation(imageId)).build());
        }

        public Builder imageScanStatus(ImageScanStatus var1);

        default public Builder imageScanStatus(Consumer<ImageScanStatus.Builder> imageScanStatus) {
            return this.imageScanStatus((ImageScanStatus)((ImageScanStatus.Builder)ImageScanStatus.builder().applyMutation(imageScanStatus)).build());
        }

        public Builder imageScanFindings(ImageScanFindings var1);

        default public Builder imageScanFindings(Consumer<ImageScanFindings.Builder> imageScanFindings) {
            return this.imageScanFindings((ImageScanFindings)((ImageScanFindings.Builder)ImageScanFindings.builder().applyMutation(imageScanFindings)).build());
        }

        public Builder nextToken(String var1);
    }
}

