/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.services.ecr.model.Layer;
import software.amazon.awssdk.services.ecr.model.LayerFailure;
import software.amazon.awssdk.services.ecr.model.LayerFailureListCopier;
import software.amazon.awssdk.services.ecr.model.LayerListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchCheckLayerAvailabilityResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
    private static final SdkField<List<Layer>> LAYERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("layers").getter(BatchCheckLayerAvailabilityResponse.getter(BatchCheckLayerAvailabilityResponse::layers)).setter(BatchCheckLayerAvailabilityResponse.setter(Builder::layers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("layers").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Layer::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<LayerFailure>> FAILURES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("failures").getter(BatchCheckLayerAvailabilityResponse.getter(BatchCheckLayerAvailabilityResponse::failures)).setter(BatchCheckLayerAvailabilityResponse.setter(Builder::failures)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failures").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LayerFailure::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAYERS_FIELD, FAILURES_FIELD));
    private final List<Layer> layers;
    private final List<LayerFailure> failures;

    private BatchCheckLayerAvailabilityResponse(BuilderImpl builder) {
        super(builder);
        this.layers = builder.layers;
        this.failures = builder.failures;
    }

    public boolean hasLayers() {
        return this.layers != null && !(this.layers instanceof SdkAutoConstructList);
    }

    public List<Layer> layers() {
        return this.layers;
    }

    public boolean hasFailures() {
        return this.failures != null && !(this.failures instanceof SdkAutoConstructList);
    }

    public List<LayerFailure> failures() {
        return this.failures;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.layers());
        hashCode = 31 * hashCode + Objects.hashCode(this.failures());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResponse)) {
            return false;
        }
        BatchCheckLayerAvailabilityResponse other = (BatchCheckLayerAvailabilityResponse)((Object)obj);
        return Objects.equals(this.layers(), other.layers()) && Objects.equals(this.failures(), other.failures());
    }

    public String toString() {
        return ToString.builder((String)"BatchCheckLayerAvailabilityResponse").add("Layers", this.layers()).add("Failures", this.failures()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "layers": {
                return Optional.ofNullable(clazz.cast(this.layers()));
            }
            case "failures": {
                return Optional.ofNullable(clazz.cast(this.failures()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchCheckLayerAvailabilityResponse, T> g) {
        return obj -> g.apply((BatchCheckLayerAvailabilityResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<Layer> layers = DefaultSdkAutoConstructList.getInstance();
        private List<LayerFailure> failures = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchCheckLayerAvailabilityResponse model) {
            super(model);
            this.layers(model.layers);
            this.failures(model.failures);
        }

        public final Collection<Layer.Builder> getLayers() {
            return this.layers != null ? (Collection)this.layers.stream().map(Layer::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder layers(Collection<Layer> layers) {
            this.layers = LayerListCopier.copy(layers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Layer ... layers) {
            this.layers(Arrays.asList(layers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder layers(Consumer<Layer.Builder> ... layers) {
            this.layers(Stream.of(layers).map(c -> (Layer)((Layer.Builder)Layer.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setLayers(Collection<Layer.BuilderImpl> layers) {
            this.layers = LayerListCopier.copyFromBuilder(layers);
        }

        public final Collection<LayerFailure.Builder> getFailures() {
            return this.failures != null ? (Collection)this.failures.stream().map(LayerFailure::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder failures(Collection<LayerFailure> failures) {
            this.failures = LayerFailureListCopier.copy(failures);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(LayerFailure ... failures) {
            this.failures(Arrays.asList(failures));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder failures(Consumer<LayerFailure.Builder> ... failures) {
            this.failures(Stream.of(failures).map(c -> (LayerFailure)((LayerFailure.Builder)LayerFailure.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setFailures(Collection<LayerFailure.BuilderImpl> failures) {
            this.failures = LayerFailureListCopier.copyFromBuilder(failures);
        }

        @Override
        public BatchCheckLayerAvailabilityResponse build() {
            return new BatchCheckLayerAvailabilityResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchCheckLayerAvailabilityResponse> {
        public Builder layers(Collection<Layer> var1);

        public Builder layers(Layer ... var1);

        public Builder layers(Consumer<Layer.Builder> ... var1);

        public Builder failures(Collection<LayerFailure> var1);

        public Builder failures(LayerFailure ... var1);

        public Builder failures(Consumer<LayerFailure.Builder> ... var1);
    }
}

