/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.ecr.model.EcrRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutImageRequest
extends EcrRequest
implements ToCopyableBuilder<Builder, PutImageRequest> {
    private static final SdkField<String> REGISTRY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutImageRequest.getter(PutImageRequest::registryId)).setter(PutImageRequest.setter(Builder::registryId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("registryId").build()}).build();
    private static final SdkField<String> REPOSITORY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutImageRequest.getter(PutImageRequest::repositoryName)).setter(PutImageRequest.setter(Builder::repositoryName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("repositoryName").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutImageRequest.getter(PutImageRequest::imageManifest)).setter(PutImageRequest.setter(Builder::imageManifest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifest").build()}).build();
    private static final SdkField<String> IMAGE_MANIFEST_MEDIA_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutImageRequest.getter(PutImageRequest::imageManifestMediaType)).setter(PutImageRequest.setter(Builder::imageManifestMediaType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageManifestMediaType").build()}).build();
    private static final SdkField<String> IMAGE_TAG_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutImageRequest.getter(PutImageRequest::imageTag)).setter(PutImageRequest.setter(Builder::imageTag)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageTag").build()}).build();
    private static final SdkField<String> IMAGE_DIGEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(PutImageRequest.getter(PutImageRequest::imageDigest)).setter(PutImageRequest.setter(Builder::imageDigest)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("imageDigest").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGISTRY_ID_FIELD, REPOSITORY_NAME_FIELD, IMAGE_MANIFEST_FIELD, IMAGE_MANIFEST_MEDIA_TYPE_FIELD, IMAGE_TAG_FIELD, IMAGE_DIGEST_FIELD));
    private final String registryId;
    private final String repositoryName;
    private final String imageManifest;
    private final String imageManifestMediaType;
    private final String imageTag;
    private final String imageDigest;

    private PutImageRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageManifest = builder.imageManifest;
        this.imageManifestMediaType = builder.imageManifestMediaType;
        this.imageTag = builder.imageTag;
        this.imageDigest = builder.imageDigest;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String imageManifest() {
        return this.imageManifest;
    }

    public String imageManifestMediaType() {
        return this.imageManifestMediaType;
    }

    public String imageTag() {
        return this.imageTag;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifestMediaType());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTag());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageRequest)) {
            return false;
        }
        PutImageRequest other = (PutImageRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageManifest(), other.imageManifest()) && Objects.equals(this.imageManifestMediaType(), other.imageManifestMediaType()) && Objects.equals(this.imageTag(), other.imageTag()) && Objects.equals(this.imageDigest(), other.imageDigest());
    }

    public String toString() {
        return ToString.builder((String)"PutImageRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageManifest", (Object)this.imageManifest()).add("ImageManifestMediaType", (Object)this.imageManifestMediaType()).add("ImageTag", (Object)this.imageTag()).add("ImageDigest", (Object)this.imageDigest()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.ofNullable(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.ofNullable(clazz.cast(this.repositoryName()));
            }
            case "imageManifest": {
                return Optional.ofNullable(clazz.cast(this.imageManifest()));
            }
            case "imageManifestMediaType": {
                return Optional.ofNullable(clazz.cast(this.imageManifestMediaType()));
            }
            case "imageTag": {
                return Optional.ofNullable(clazz.cast(this.imageTag()));
            }
            case "imageDigest": {
                return Optional.ofNullable(clazz.cast(this.imageDigest()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutImageRequest, T> g) {
        return obj -> g.apply((PutImageRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String imageManifest;
        private String imageManifestMediaType;
        private String imageTag;
        private String imageDigest;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageRequest model) {
            super(model);
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageManifest(model.imageManifest);
            this.imageManifestMediaType(model.imageManifestMediaType);
            this.imageTag(model.imageTag);
            this.imageDigest(model.imageDigest);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getImageManifest() {
            return this.imageManifest;
        }

        @Override
        public final Builder imageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
            return this;
        }

        public final void setImageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
        }

        public final String getImageManifestMediaType() {
            return this.imageManifestMediaType;
        }

        @Override
        public final Builder imageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
            return this;
        }

        public final void setImageManifestMediaType(String imageManifestMediaType) {
            this.imageManifestMediaType = imageManifestMediaType;
        }

        public final String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutImageRequest build() {
            return new PutImageRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutImageRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageManifest(String var1);

        public Builder imageManifestMediaType(String var1);

        public Builder imageTag(String var1);

        public Builder imageDigest(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

