/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.ecr.model.AuthorizationData;
import software.amazon.awssdk.services.ecr.model.AuthorizationDataListCopier;
import software.amazon.awssdk.services.ecr.model.EcrResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAuthorizationTokenResponse
extends EcrResponse
implements ToCopyableBuilder<Builder, GetAuthorizationTokenResponse> {
    private static final SdkField<List<AuthorizationData>> AUTHORIZATION_DATA_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(GetAuthorizationTokenResponse.getter(GetAuthorizationTokenResponse::authorizationData)).setter(GetAuthorizationTokenResponse.setter(Builder::authorizationData)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationData").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AuthorizationData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_DATA_FIELD));
    private final List<AuthorizationData> authorizationData;

    private GetAuthorizationTokenResponse(BuilderImpl builder) {
        super(builder);
        this.authorizationData = builder.authorizationData;
    }

    public List<AuthorizationData> authorizationData() {
        return this.authorizationData;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizationData());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAuthorizationTokenResponse)) {
            return false;
        }
        GetAuthorizationTokenResponse other = (GetAuthorizationTokenResponse)((Object)obj);
        return Objects.equals(this.authorizationData(), other.authorizationData());
    }

    public String toString() {
        return ToString.builder((String)"GetAuthorizationTokenResponse").add("AuthorizationData", this.authorizationData()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authorizationData": {
                return Optional.ofNullable(clazz.cast(this.authorizationData()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetAuthorizationTokenResponse, T> g) {
        return obj -> g.apply((GetAuthorizationTokenResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends EcrResponse.BuilderImpl
    implements Builder {
        private List<AuthorizationData> authorizationData = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetAuthorizationTokenResponse model) {
            super(model);
            this.authorizationData(model.authorizationData);
        }

        public final Collection<AuthorizationData.Builder> getAuthorizationData() {
            return this.authorizationData != null ? (Collection)this.authorizationData.stream().map(AuthorizationData::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder authorizationData(Collection<AuthorizationData> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copy(authorizationData);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(AuthorizationData ... authorizationData) {
            this.authorizationData(Arrays.asList(authorizationData));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder authorizationData(Consumer<AuthorizationData.Builder> ... authorizationData) {
            this.authorizationData(Stream.of(authorizationData).map(c -> (AuthorizationData)((AuthorizationData.Builder)AuthorizationData.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAuthorizationData(Collection<AuthorizationData.BuilderImpl> authorizationData) {
            this.authorizationData = AuthorizationDataListCopier.copyFromBuilder(authorizationData);
        }

        @Override
        public GetAuthorizationTokenResponse build() {
            return new GetAuthorizationTokenResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends EcrResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAuthorizationTokenResponse> {
        public Builder authorizationData(Collection<AuthorizationData> var1);

        public Builder authorizationData(AuthorizationData ... var1);

        public Builder authorizationData(Consumer<AuthorizationData.Builder> ... var1);
    }
}

