/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ecr.ECRClient;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeRepositoriesResponse;
import software.amazon.awssdk.services.ecr.model.Repository;

public final class DescribeRepositoriesPaginator
implements SdkIterable<DescribeRepositoriesResponse> {
    private final ECRClient client;
    private final DescribeRepositoriesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeRepositoriesPaginator(ECRClient client, DescribeRepositoriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeRepositoriesResponseFetcher();
    }

    public Iterator<DescribeRepositoriesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<Repository> repositories() {
        Function<DescribeRepositoriesResponse, Iterator> getIterator = response -> response != null ? response.repositories().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeRepositoriesResponseFetcher
    implements NextPageFetcher<DescribeRepositoriesResponse> {
        private DescribeRepositoriesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeRepositoriesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeRepositoriesResponse nextPage(DescribeRepositoriesResponse previousPage) {
            if (previousPage == null) {
                return DescribeRepositoriesPaginator.this.client.describeRepositories(DescribeRepositoriesPaginator.this.firstRequest);
            }
            return DescribeRepositoriesPaginator.this.client.describeRepositories((DescribeRepositoriesRequest)((Object)DescribeRepositoriesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

