/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.paginators;

import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.NextPageFetcher;
import software.amazon.awssdk.core.pagination.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.services.ecr.ECRClient;
import software.amazon.awssdk.services.ecr.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ecr.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ecr.model.ImageDetail;

public final class DescribeImagesPaginator
implements SdkIterable<DescribeImagesResponse> {
    private final ECRClient client;
    private final DescribeImagesRequest firstRequest;
    private final NextPageFetcher nextPageFetcher;

    public DescribeImagesPaginator(ECRClient client, DescribeImagesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeImagesResponseFetcher();
    }

    public Iterator<DescribeImagesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public SdkIterable<ImageDetail> imageDetails() {
        Function<DescribeImagesResponse, Iterator> getIterator = response -> response != null ? response.imageDetails().iterator() : null;
        return new PaginatedItemsIterable((SdkIterable)this, getIterator);
    }

    private class DescribeImagesResponseFetcher
    implements NextPageFetcher<DescribeImagesResponse> {
        private DescribeImagesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeImagesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public DescribeImagesResponse nextPage(DescribeImagesResponse previousPage) {
            if (previousPage == null) {
                return DescribeImagesPaginator.this.client.describeImages(DescribeImagesPaginator.this.firstRequest);
            }
            return DescribeImagesPaginator.this.client.describeImages((DescribeImagesRequest)((Object)DescribeImagesPaginator.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

