/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class UploadLayerPartResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, UploadLayerPartResponse> {
    private final String registryId;
    private final String repositoryName;
    private final String uploadId;
    private final Long lastByteReceived;

    private UploadLayerPartResponse(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.uploadId = builder.uploadId;
        this.lastByteReceived = builder.lastByteReceived;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String uploadId() {
        return this.uploadId;
    }

    public Long lastByteReceived() {
        return this.lastByteReceived;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastByteReceived());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UploadLayerPartResponse)) {
            return false;
        }
        UploadLayerPartResponse other = (UploadLayerPartResponse)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.lastByteReceived(), other.lastByteReceived());
    }

    public String toString() {
        return ToString.builder((String)"UploadLayerPartResponse").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("UploadId", (Object)this.uploadId()).add("LastByteReceived", (Object)this.lastByteReceived()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "uploadId": {
                return Optional.of(clazz.cast(this.uploadId()));
            }
            case "lastByteReceived": {
                return Optional.of(clazz.cast(this.lastByteReceived()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String uploadId;
        private Long lastByteReceived;

        private BuilderImpl() {
        }

        private BuilderImpl(UploadLayerPartResponse model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.uploadId(model.uploadId);
            this.lastByteReceived(model.lastByteReceived);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        public final Long getLastByteReceived() {
            return this.lastByteReceived;
        }

        @Override
        public final Builder lastByteReceived(Long lastByteReceived) {
            this.lastByteReceived = lastByteReceived;
            return this;
        }

        public final void setLastByteReceived(Long lastByteReceived) {
            this.lastByteReceived = lastByteReceived;
        }

        @Override
        public UploadLayerPartResponse build() {
            return new UploadLayerPartResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, UploadLayerPartResponse> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder uploadId(String var1);

        public Builder lastByteReceived(Long var1);
    }
}

