/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ecr.model.ECRRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class PutImageRequest
extends ECRRequest
implements ToCopyableBuilder<Builder, PutImageRequest> {
    private final String registryId;
    private final String repositoryName;
    private final String imageManifest;
    private final String imageTag;

    private PutImageRequest(BuilderImpl builder) {
        super(builder);
        this.registryId = builder.registryId;
        this.repositoryName = builder.repositoryName;
        this.imageManifest = builder.imageManifest;
        this.imageTag = builder.imageTag;
    }

    public String registryId() {
        return this.registryId;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    public String imageManifest() {
        return this.imageManifest;
    }

    public String imageTag() {
        return this.imageTag;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.registryId());
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageManifest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutImageRequest)) {
            return false;
        }
        PutImageRequest other = (PutImageRequest)((Object)obj);
        return Objects.equals(this.registryId(), other.registryId()) && Objects.equals(this.repositoryName(), other.repositoryName()) && Objects.equals(this.imageManifest(), other.imageManifest()) && Objects.equals(this.imageTag(), other.imageTag());
    }

    public String toString() {
        return ToString.builder((String)"PutImageRequest").add("RegistryId", (Object)this.registryId()).add("RepositoryName", (Object)this.repositoryName()).add("ImageManifest", (Object)this.imageManifest()).add("ImageTag", (Object)this.imageTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "registryId": {
                return Optional.of(clazz.cast(this.registryId()));
            }
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
            case "imageManifest": {
                return Optional.of(clazz.cast(this.imageManifest()));
            }
            case "imageTag": {
                return Optional.of(clazz.cast(this.imageTag()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRRequest.BuilderImpl
    implements Builder {
        private String registryId;
        private String repositoryName;
        private String imageManifest;
        private String imageTag;

        private BuilderImpl() {
        }

        private BuilderImpl(PutImageRequest model) {
            this.registryId(model.registryId);
            this.repositoryName(model.repositoryName);
            this.imageManifest(model.imageManifest);
            this.imageTag(model.imageTag);
        }

        public final String getRegistryId() {
            return this.registryId;
        }

        @Override
        public final Builder registryId(String registryId) {
            this.registryId = registryId;
            return this;
        }

        public final void setRegistryId(String registryId) {
            this.registryId = registryId;
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        public final String getImageManifest() {
            return this.imageManifest;
        }

        @Override
        public final Builder imageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
            return this;
        }

        public final void setImageManifest(String imageManifest) {
            this.imageManifest = imageManifest;
        }

        public final String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public PutImageRequest build() {
            return new PutImageRequest(this);
        }
    }

    public static interface Builder
    extends ECRRequest.Builder,
    CopyableBuilder<Builder, PutImageRequest> {
        public Builder registryId(String var1);

        public Builder repositoryName(String var1);

        public Builder imageManifest(String var1);

        public Builder imageTag(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

