/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.ecr.transform.ImageIdentifierMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ImageIdentifier
implements StructuredPojo,
ToCopyableBuilder<Builder, ImageIdentifier> {
    private final String imageDigest;
    private final String imageTag;

    private ImageIdentifier(BuilderImpl builder) {
        this.imageDigest = builder.imageDigest;
        this.imageTag = builder.imageTag;
    }

    public String imageDigest() {
        return this.imageDigest;
    }

    public String imageTag() {
        return this.imageTag;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDigest());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageTag());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImageIdentifier)) {
            return false;
        }
        ImageIdentifier other = (ImageIdentifier)obj;
        return Objects.equals(this.imageDigest(), other.imageDigest()) && Objects.equals(this.imageTag(), other.imageTag());
    }

    public String toString() {
        return ToString.builder((String)"ImageIdentifier").add("ImageDigest", (Object)this.imageDigest()).add("ImageTag", (Object)this.imageTag()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageDigest": {
                return Optional.of(clazz.cast(this.imageDigest()));
            }
            case "imageTag": {
                return Optional.of(clazz.cast(this.imageTag()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ImageIdentifierMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String imageDigest;
        private String imageTag;

        private BuilderImpl() {
        }

        private BuilderImpl(ImageIdentifier model) {
            this.imageDigest(model.imageDigest);
            this.imageTag(model.imageTag);
        }

        public final String getImageDigest() {
            return this.imageDigest;
        }

        @Override
        public final Builder imageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
            return this;
        }

        public final void setImageDigest(String imageDigest) {
            this.imageDigest = imageDigest;
        }

        public final String getImageTag() {
            return this.imageTag;
        }

        @Override
        public final Builder imageTag(String imageTag) {
            this.imageTag = imageTag;
            return this;
        }

        public final void setImageTag(String imageTag) {
            this.imageTag = imageTag;
        }

        public ImageIdentifier build() {
            return new ImageIdentifier(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ImageIdentifier> {
        public Builder imageDigest(String var1);

        public Builder imageTag(String var1);
    }
}

