/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.ecr.model.ECRResponse;
import software.amazon.awssdk.services.ecr.model.ImageDetail;
import software.amazon.awssdk.services.ecr.model.ImageDetailListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeImagesResponse
extends ECRResponse
implements ToCopyableBuilder<Builder, DescribeImagesResponse> {
    private final List<ImageDetail> imageDetails;
    private final String nextToken;

    private DescribeImagesResponse(BuilderImpl builder) {
        super(builder);
        this.imageDetails = builder.imageDetails;
        this.nextToken = builder.nextToken;
    }

    public List<ImageDetail> imageDetails() {
        return this.imageDetails;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.imageDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeImagesResponse)) {
            return false;
        }
        DescribeImagesResponse other = (DescribeImagesResponse)((Object)obj);
        return Objects.equals(this.imageDetails(), other.imageDetails()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeImagesResponse").add("ImageDetails", this.imageDetails()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "imageDetails": {
                return Optional.of(clazz.cast(this.imageDetails()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRResponse.BuilderImpl
    implements Builder {
        private List<ImageDetail> imageDetails;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeImagesResponse model) {
            this.imageDetails(model.imageDetails);
            this.nextToken(model.nextToken);
        }

        public final Collection<ImageDetail.Builder> getImageDetails() {
            return this.imageDetails != null ? (Collection)this.imageDetails.stream().map(ImageDetail::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder imageDetails(Collection<ImageDetail> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copy(imageDetails);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder imageDetails(ImageDetail ... imageDetails) {
            this.imageDetails(Arrays.asList(imageDetails));
            return this;
        }

        public final void setImageDetails(Collection<ImageDetail.BuilderImpl> imageDetails) {
            this.imageDetails = ImageDetailListCopier.copyFromBuilder(imageDetails);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public DescribeImagesResponse build() {
            return new DescribeImagesResponse(this);
        }
    }

    public static interface Builder
    extends ECRResponse.Builder,
    CopyableBuilder<Builder, DescribeImagesResponse> {
        public Builder imageDetails(Collection<ImageDetail> var1);

        public Builder imageDetails(ImageDetail ... var1);

        public Builder nextToken(String var1);
    }
}

