/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ecr.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.ecr.model.ECRRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateRepositoryRequest
extends ECRRequest
implements ToCopyableBuilder<Builder, CreateRepositoryRequest> {
    private final String repositoryName;

    private CreateRepositoryRequest(BuilderImpl builder) {
        super(builder);
        this.repositoryName = builder.repositoryName;
    }

    public String repositoryName() {
        return this.repositoryName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.repositoryName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateRepositoryRequest)) {
            return false;
        }
        CreateRepositoryRequest other = (CreateRepositoryRequest)((Object)obj);
        return Objects.equals(this.repositoryName(), other.repositoryName());
    }

    public String toString() {
        return ToString.builder((String)"CreateRepositoryRequest").add("RepositoryName", (Object)this.repositoryName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "repositoryName": {
                return Optional.of(clazz.cast(this.repositoryName()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends ECRRequest.BuilderImpl
    implements Builder {
        private String repositoryName;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateRepositoryRequest model) {
            this.repositoryName(model.repositoryName);
        }

        public final String getRepositoryName() {
            return this.repositoryName;
        }

        @Override
        public final Builder repositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
            return this;
        }

        public final void setRepositoryName(String repositoryName) {
            this.repositoryName = repositoryName;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateRepositoryRequest build() {
            return new CreateRepositoryRequest(this);
        }
    }

    public static interface Builder
    extends ECRRequest.Builder,
    CopyableBuilder<Builder, CreateRepositoryRequest> {
        public Builder repositoryName(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

